/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.tile;

import java.util.HashMap;
import java.util.Map;
import mrriegel.storagenetwork.helper.StackWrapper;
import mrriegel.storagenetwork.helper.Util;
import mrriegel.storagenetwork.tile.TileConnectable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public abstract class AbstractFilterTile
extends TileConnectable {
    private Map<Integer, StackWrapper> filter = new HashMap<Integer, StackWrapper>();
    private Map<Integer, Boolean> ores = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> metas = new HashMap<Integer, Boolean>();
    private boolean white;
    private int priority;
    private Direction way = Direction.BOTH;

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readSettings(compound);
    }

    public void readSettings(NBTTagCompound compound) {
        int i;
        int i2;
        this.white = compound.func_74767_n("white");
        this.priority = compound.func_74762_e("prio");
        NBTTagList invList = compound.func_150295_c("crunchTE", 10);
        this.filter = new HashMap<Integer, StackWrapper>();
        for (int i3 = 0; i3 < invList.func_74745_c(); ++i3) {
            NBTTagCompound stackTag = invList.func_150305_b(i3);
            byte slot = stackTag.func_74771_c("Slot");
            this.filter.put(Integer.valueOf(slot), StackWrapper.loadStackWrapperFromNBT(stackTag));
        }
        NBTTagList oreList = compound.func_150295_c("ores", 10);
        this.ores = new HashMap<Integer, Boolean>();
        for (i2 = 0; i2 < 18; ++i2) {
            this.ores.put(i2, false);
        }
        for (i2 = 0; i2 < oreList.func_74745_c(); ++i2) {
            NBTTagCompound stackTag = oreList.func_150305_b(i2);
            byte slot = stackTag.func_74771_c("Slot");
            this.ores.put(Integer.valueOf(slot), stackTag.func_74767_n("Ore"));
        }
        NBTTagList metaList = compound.func_150295_c("metas", 10);
        this.metas = new HashMap<Integer, Boolean>();
        for (i = 0; i < 18; ++i) {
            this.metas.put(i, true);
        }
        for (i = 0; i < metaList.func_74745_c(); ++i) {
            NBTTagCompound stackTag = metaList.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            this.metas.put(Integer.valueOf(slot), stackTag.func_74767_n("Meta"));
        }
        try {
            this.way = Direction.valueOf(compound.func_74779_i("way"));
        }
        catch (Exception e) {
            this.way = Direction.BOTH;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeSettings(compound);
        return compound;
    }

    public void writeSettings(NBTTagCompound compound) {
        compound.func_74757_a("white", this.white);
        compound.func_74768_a("prio", this.priority);
        NBTTagList invList = new NBTTagList();
        for (int i = 0; i < 18; ++i) {
            if (this.filter.get(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.filter.get(i).writeToNBT(stackTag);
            invList.func_74742_a((NBTBase)stackTag);
        }
        compound.func_74782_a("crunchTE", (NBTBase)invList);
        NBTTagList oreList = new NBTTagList();
        for (int i = 0; i < 18; ++i) {
            if (this.ores.get(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            stackTag.func_74757_a("Ore", this.ores.get(i).booleanValue());
            oreList.func_74742_a((NBTBase)stackTag);
        }
        compound.func_74782_a("ores", (NBTBase)oreList);
        NBTTagList metaList = new NBTTagList();
        for (int i = 0; i < 18; ++i) {
            if (this.metas.get(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            stackTag.func_74757_a("Meta", this.metas.get(i).booleanValue());
            metaList.func_74742_a((NBTBase)stackTag);
        }
        compound.func_74782_a("metas", (NBTBase)metaList);
        compound.func_74778_a("way", this.way.toString());
    }

    public boolean canTransfer(ItemStack stack, Direction way) {
        if (this.isStorage() && !this.way.match(way)) {
            return false;
        }
        if (this.isWhite()) {
            boolean tmp = false;
            for (int i = 0; i < 18; ++i) {
                ItemStack s;
                if (this.getFilter().get(i) == null || (s = this.getFilter().get(i).getStack()) == null) continue;
                boolean ore = this.getOre(i);
                boolean meta = this.getMeta(i);
                if (!(ore ? Util.equalOreDict(stack, s) : (meta ? stack.func_77969_a(s) : stack.func_77973_b() == s.func_77973_b()))) continue;
                tmp = true;
                break;
            }
            return tmp;
        }
        boolean tmp = true;
        for (int i = 0; i < 18; ++i) {
            ItemStack s;
            if (this.getFilter().get(i) == null || (s = this.getFilter().get(i).getStack()) == null || s.func_190926_b()) continue;
            boolean ore = this.getOre(i);
            boolean meta = this.getMeta(i);
            if (!(ore ? Util.equalOreDict(stack, s) : (meta ? stack.func_77969_a(s) : stack.func_77973_b() == s.func_77973_b()))) continue;
            tmp = false;
            break;
        }
        return tmp;
    }

    public abstract IItemHandler getInventory();

    public abstract BlockPos getSource();

    public abstract boolean isStorage();

    public boolean getOre(int i) {
        return this.getOres().get(i) == null ? false : this.getOres().get(i);
    }

    public boolean getMeta(int i) {
        return this.getMetas().get(i) == null ? true : this.getMetas().get(i);
    }

    public Map<Integer, StackWrapper> getFilter() {
        return this.filter;
    }

    public void setFilter(Map<Integer, StackWrapper> filter) {
        this.filter = filter;
    }

    public Map<Integer, Boolean> getOres() {
        return this.ores;
    }

    public void setOres(Map<Integer, Boolean> ores) {
        this.ores = ores;
    }

    public Map<Integer, Boolean> getMetas() {
        return this.metas;
    }

    public void setMetas(Map<Integer, Boolean> metas) {
        this.metas = metas;
    }

    public boolean isWhite() {
        return this.white;
    }

    public void setWhite(boolean white) {
        this.white = white;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Direction getWay() {
        return this.way;
    }

    public void setWay(Direction way) {
        this.way = way;
    }

    public static enum Direction {
        IN,
        OUT,
        BOTH;


        public boolean match(Direction way) {
            if (this == BOTH || way == BOTH) {
                return true;
            }
            return this == way;
        }

        public Direction next() {
            return Direction.values()[(this.ordinal() + 1) % Direction.values().length];
        }
    }
}

