/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectable;
import com.lothrazar.storagenetwork.registry.StorageNetworkCapabilities;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileConnectable
extends TileEntity {
    private final CapabilityConnectable connectable = new CapabilityConnectable();

    public TileConnectable(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.connectable.setPos(new DimPos(this.field_145850_b, this.field_174879_c));
    }

    public void func_230337_a_(BlockState bs, CompoundNBT compound) {
        if (compound.func_74764_b("connectable")) {
            this.connectable.deserializeNBT(compound.func_74775_l("connectable"));
        }
        super.func_230337_a_(bs, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("connectable", (INBT)this.connectable.serializeNBT());
        return super.func_189515_b(compound);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT syncData = new CompoundNBT();
        this.func_189515_b(syncData);
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, syncData);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (StorageNetwork.config.doReloadOnChunk() && this.connectable != null && this.connectable.getMainPos() != null) {
            try {
                TileMain maybe = UtilTileEntity.getTileMainForConnectable(this.connectable);
                if (maybe != null) {
                    maybe.refreshNetwork();
                }
            }
            catch (Exception e) {
                StorageNetwork.LOGGER.info("Error on chunk unload " + e);
            }
        }
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == StorageNetworkCapabilities.CONNECTABLE_CAPABILITY) {
            LazyOptional cap = LazyOptional.of(() -> this.connectable);
            return cap.cast();
        }
        return super.getCapability(capability, facing);
    }

    public DimPos getMain() {
        return this.connectable.getMainPos();
    }
}

