/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.cable.linkfilter;

import com.google.common.collect.Lists;
import com.lothrazar.storagenetwork.api.IGuiPrivate;
import com.lothrazar.storagenetwork.block.cable.linkfilter.ContainerCableFilter;
import com.lothrazar.storagenetwork.capability.handler.FilterItemStackHandler;
import com.lothrazar.storagenetwork.gui.ButtonRequest;
import com.lothrazar.storagenetwork.gui.ItemSlotNetwork;
import com.lothrazar.storagenetwork.network.CableDataMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiCableFilter
extends ContainerScreen<ContainerCableFilter>
implements IGuiPrivate {
    private final ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/cable.png");
    ContainerCableFilter containerCableLink;
    private ButtonRequest btnMinus;
    private ButtonRequest btnPlus;
    private ButtonRequest btnWhite;
    private ButtonRequest btnImport;
    private boolean isAllowlist;
    private List<ItemSlotNetwork> itemSlotsGhost;
    public static final int SLOT_SIZE = 18;

    public GuiCableFilter(ContainerCableFilter containerCableFilter, PlayerInventory inv, ITextComponent name) {
        super((Container)containerCableFilter, inv, name);
        this.containerCableLink = containerCableFilter;
    }

    @Override
    public void renderStackTooltip(MatrixStack ms, ItemStack stack, int mousex, int mousey) {
        super.func_230457_a_(ms, stack, mousex, mousey);
    }

    @Override
    public void drawGradient(MatrixStack ms, int x, int y, int x2, int y2, int u, int v) {
        super.func_238468_a_(ms, x, y, x2, y2, u, v);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.isAllowlist = this.containerCableLink.cap.getFilter().isAllowList;
        int x = this.field_147003_i + 7;
        int y = this.field_147009_r + 8;
        this.btnMinus = (ButtonRequest)this.func_230480_a_((Widget)new ButtonRequest(x, y, "", p -> this.syncData(-1)));
        this.btnMinus.setTextureId(ButtonRequest.TextureEnum.MINUS);
        this.btnPlus = (ButtonRequest)this.func_230480_a_((Widget)new ButtonRequest(x += 30, y, "", p -> this.syncData(1)));
        this.btnPlus.setTextureId(ButtonRequest.TextureEnum.PLUS);
        this.btnWhite = (ButtonRequest)this.func_230480_a_((Widget)new ButtonRequest(x += 20, y, "", p -> {
            this.isAllowlist = !this.isAllowlist;
            this.syncData(0);
        }));
        this.btnImport = (ButtonRequest)this.func_230480_a_((Widget)new ButtonRequest(x += 20, y, "", p -> this.importFilterSlots()));
        this.btnImport.setTextureId(ButtonRequest.TextureEnum.IMPORT);
    }

    private void importFilterSlots() {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableDataMessage(CableDataMessage.CableMessageType.IMPORT_FILTER.ordinal()));
    }

    private void sendStackSlot(int value, ItemStack stack) {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableDataMessage(CableDataMessage.CableMessageType.SAVE_FITLER.ordinal(), value, stack));
    }

    private void syncData(int priority) {
        PacketRegistry.INSTANCE.sendToServer((Object)new CableDataMessage(CableDataMessage.CableMessageType.SYNC_DATA.ordinal(), priority, this.isAllowlist));
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(ms);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        this.func_230459_a_(ms, mouseX, mouseY);
        if (this.containerCableLink == null || this.containerCableLink.cap == null) {
            return;
        }
        this.btnWhite.setTextureId(this.isAllowlist ? ButtonRequest.TextureEnum.ALLOWLIST : ButtonRequest.TextureEnum.IGNORELIST);
    }

    public void func_230451_b_(MatrixStack ms, int mouseX, int mouseY) {
        int priority = this.containerCableLink.cap.getPriority();
        this.field_230712_o_.func_238421_b_(ms, String.valueOf(priority), (float)(30 - this.field_230712_o_.func_78256_a(String.valueOf(priority)) / 2), 14.0f, 0x404040);
        this.drawTooltips(ms, mouseX, mouseY);
    }

    private void drawTooltips(MatrixStack ms, int mouseX, int mouseY) {
        if (this.btnImport != null && this.btnImport.func_231047_b_(mouseX, mouseY)) {
            this.renderTooltip(ms, Lists.newArrayList((Object[])new StringTextComponent[]{new StringTextComponent("gui.storagenetwork.import")}), mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_230712_o_);
        }
        if (this.btnWhite != null && this.btnWhite.func_231047_b_(mouseX, mouseY)) {
            this.renderTooltip(ms, Lists.newArrayList((Object[])new StringTextComponent[]{new StringTextComponent(this.isAllowlist ? "gui.storagenetwork.gui.whitelist" : "gui.storagenetwork.gui.blacklist")}), mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_230712_o_);
        }
        if (this.btnMinus != null && this.btnMinus.func_231047_b_(mouseX, mouseY)) {
            this.renderTooltip(ms, Lists.newArrayList((Object[])new StringTextComponent[]{new StringTextComponent("gui.storagenetwork.priority.down")}), mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_230712_o_);
        }
        if (this.btnPlus != null && this.btnPlus.func_231047_b_(mouseX, mouseY)) {
            this.renderTooltip(ms, Lists.newArrayList((Object[])new StringTextComponent[]{new StringTextComponent("gui.storagenetwork.priority.up")}), mouseX - this.field_147003_i, mouseY - this.field_147009_r, this.field_230712_o_);
        }
    }

    protected void func_230450_a_(MatrixStack ms, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.texture);
        int xCenter = (this.field_230708_k_ - this.field_146999_f) / 2;
        int yCenter = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(ms, xCenter, yCenter, 0, 0, this.field_146999_f, this.field_147000_g);
        this.itemSlotsGhost = Lists.newArrayList();
        int rows = 2;
        int cols = 9;
        int index = 0;
        int y = 35;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                ItemStack stack = this.containerCableLink.cap.getFilter().getStackInSlot(index);
                int x = 8 + col * 18;
                this.itemSlotsGhost.add(new ItemSlotNetwork(this, stack, this.field_147003_i + x, this.field_147009_r + y, stack.func_190916_E(), this.field_147003_i, this.field_147009_r, true));
                ++index;
            }
            y += 18;
        }
        for (ItemSlotNetwork s : this.itemSlotsGhost) {
            s.drawSlot(ms, this.field_230712_o_, mouseX, mouseY);
        }
    }

    public void setFilterItems(List<ItemStack> stacks) {
        FilterItemStackHandler filter = this.containerCableLink.cap.getFilter();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack s = stacks.get(i);
            filter.setStackInSlot(i, s);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        ItemStack mouse = this.field_230706_i_.field_71439_g.field_71071_by.func_70445_o();
        for (int i = 0; i < this.itemSlotsGhost.size(); ++i) {
            ItemSlotNetwork slot = this.itemSlotsGhost.get(i);
            if (!slot.isMouseOverSlot((int)mouseX, (int)mouseY)) continue;
            if (!slot.getStack().func_190926_b()) {
                if (mouseButton == 1) {
                    int direction = GuiCableFilter.func_231173_s_() ? -1 : 1;
                    int newCount = Math.min(64, slot.getStack().func_190916_E() + direction);
                    if (newCount < 1) {
                        newCount = 1;
                    }
                    slot.getStack().func_190920_e(newCount);
                } else {
                    slot.setStack(ItemStack.field_190927_a);
                }
                this.sendStackSlot(i, slot.getStack());
                return true;
            }
            slot.setStack(mouse.func_77946_l());
            this.sendStackSlot(i, mouse.func_77946_l());
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isInRegion(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.func_195359_a(x, y, width, height, mouseX, mouseY);
    }
}

