/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.block.cable.linkfilter.ContainerCableFilter;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.CapabilityConnectableLink;
import com.lothrazar.storagenetwork.network.RefreshFilterClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class CableDataMessage {
    private boolean isAllowlist;
    private final int id;
    private int value = 0;
    private ItemStack stack = ItemStack.field_190927_a;

    public CableDataMessage(int id) {
        this.id = id;
    }

    public CableDataMessage(int id, int value, boolean is) {
        this(id);
        this.value = value;
        this.isAllowlist = is;
    }

    public CableDataMessage(int id, int value, ItemStack mystack) {
        this(id);
        this.value = value;
        this.stack = mystack;
    }

    public String toString() {
        return "CableDataMessage{isAllowlist=" + this.isAllowlist + ", id=" + this.id + ", value=" + this.value + ", stack=" + this.stack + '}';
    }

    public static void handle(CableDataMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            CapabilityConnectableLink link = null;
            ContainerCableFilter container = (ContainerCableFilter)player.field_71070_bA;
            if (container == null || container.cap == null) {
                return;
            }
            link = container.cap;
            TileMain root = UtilTileEntity.getTileMainForConnectable(link.connectable);
            CableMessageType type = CableMessageType.values()[message.id];
            switch (type) {
                case IMPORT_FILTER: {
                    link.getFilter().clear();
                    int targetSlot = 0;
                    for (ItemStack filterSuggestion : link.getStoredStacks(false)) {
                        if (link.getFilter().exactStackAlreadyInList(filterSuggestion)) continue;
                        try {
                            link.getFilter().setStackInSlot(targetSlot, filterSuggestion.func_77946_l());
                            if (++targetSlot < link.getFilter().getSlots()) continue;
                        }
                        catch (Exception ex) {
                            StorageNetwork.LOGGER.error("Exception saving filter slot ", (Object)message);
                        }
                    }
                    PacketRegistry.INSTANCE.sendTo((Object)new RefreshFilterClientMessage(link.getFilter().getStacks()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                    break;
                }
                case SYNC_DATA: {
                    link.setPriority(link.getPriority() + message.value);
                    link.getFilter().setIsAllowlist(message.isAllowlist);
                    if (root == null) break;
                    root.clearCache();
                    break;
                }
                case SAVE_FITLER: {
                    link.setFilter(message.value, message.stack.func_77946_l());
                }
            }
            player.field_71135_a.func_147359_a((IPacket)container.tile.func_189518_D_());
        });
        ctx.get().setPacketHandled(true);
    }

    public static void encode(CableDataMessage msg, PacketBuffer buffer) {
        buffer.writeInt(msg.id);
        buffer.writeInt(msg.value);
        buffer.writeBoolean(msg.isAllowlist);
        buffer.func_150786_a(msg.stack.func_77955_b(new CompoundNBT()));
    }

    public static CableDataMessage decode(PacketBuffer buffer) {
        CableDataMessage c = new CableDataMessage(buffer.readInt(), buffer.readInt(), buffer.readBoolean());
        c.stack = ItemStack.func_199557_a((CompoundNBT)buffer.func_150793_b());
        return c;
    }

    public static enum CableMessageType {
        SYNC_DATA,
        IMPORT_FILTER,
        SAVE_FITLER;

    }
}

