/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import java.util.EnumSet;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.ItemSlashBladeNamed;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ResourceLocationRaw;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public class ItemSlashBladeWrapper
extends ItemSlashBladeNamed {
    private ResourceLocationRaw texture = new ResourceLocationRaw("flammpfeil.slashblade", "model/scabbard.png");
    static final String WrapItemStr = "WrapItem";

    public ItemSlashBladeWrapper(Item.ToolMaterial par2EnumToolMaterial) {
        super(par2EnumToolMaterial, 4.0f);
    }

    @Override
    public ResourceLocationRaw getModelTexture() {
        return this.texture;
    }

    public void setWrapItem(ItemStack base, ItemStack wrapTarget) {
        NBTTagCompound tag = ItemSlashBladeWrapper.getItemTagCompound(base);
        NBTTagCompound wrapTag = new NBTTagCompound();
        wrapTarget.func_77955_b(wrapTag);
        tag.func_74782_a(WrapItemStr, (NBTBase)wrapTag);
    }

    public void removeWrapItem(ItemStack stack) {
        NBTTagCompound tag = ItemSlashBladeWrapper.getItemTagCompound(stack);
        if (tag.func_74764_b(WrapItemStr)) {
            tag.func_82580_o(WrapItemStr);
        }
        TextureName.remove(tag);
        ModelName.remove(tag);
        if (tag.func_74764_b("display")) {
            tag.func_82580_o("display");
        }
        IsBroken.remove(tag);
        BaseAttackModifier.remove(tag);
        CurrentItemName.remove(tag);
        TrueItemName.remove(tag);
        stack.func_77964_b(0);
    }

    @Override
    public ItemSlashBlade.ComboSequence getNextComboSeq(ItemStack itemStack, ItemSlashBlade.ComboSequence current, boolean isRightClick, EntityPlayer player) {
        if (ItemSlashBladeWrapper.hasWrapedItem(itemStack)) {
            return super.getNextComboSeq(itemStack, current, isRightClick, player);
        }
        return ItemSlashBlade.ComboSequence.None;
    }

    public static boolean hasWrapedItem(ItemStack par1ItemStack) {
        NBTTagCompound tag = ItemSlashBladeWrapper.getItemTagCompound(par1ItemStack);
        return tag.func_74764_b(WrapItemStr);
    }

    public ItemStack getWrapedItem(ItemStack par1ItemStack) {
        ItemStack wrapItem = ItemStack.field_190927_a;
        if (ItemSlashBladeWrapper.hasWrapedItem(par1ItemStack)) {
            try {
                NBTTagCompound tag = ItemSlashBladeWrapper.getItemTagCompound(par1ItemStack);
                wrapItem = new ItemStack(tag.func_74775_l(WrapItemStr));
                if (wrapItem.func_190926_b()) {
                    this.removeWrapItem(par1ItemStack);
                    wrapItem = ItemStack.field_190927_a;
                }
            }
            catch (Throwable e) {
                this.removeWrapItem(par1ItemStack);
                wrapItem = ItemStack.field_190927_a;
            }
        }
        return wrapItem;
    }

    @Override
    public EnumSet<ItemSlashBlade.SwordType> getSwordType(ItemStack itemStack) {
        if (ItemSlashBladeWrapper.hasWrapedItem(itemStack)) {
            return super.getSwordType(itemStack);
        }
        EnumSet<ItemSlashBlade.SwordType> set = EnumSet.noneOf(ItemSlashBlade.SwordType.class);
        set.add(ItemSlashBlade.SwordType.Perfect);
        set.add(ItemSlashBlade.SwordType.Sealed);
        set.remove((Object)ItemSlashBlade.SwordType.FiercerEdge);
        return set;
    }

    @Override
    public int getMaxDamage(ItemStack stack) {
        ItemStack wrapItem;
        if (ItemSlashBladeWrapper.hasWrapedItem(stack) && !(wrapItem = this.getWrapedItem(stack)).func_190926_b()) {
            return wrapItem.func_77958_k();
        }
        return this.func_77612_l();
    }

    @Override
    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        ItemSlashBlade.ComboSequence comboSec = ItemSlashBladeWrapper.getComboSequence(ItemSlashBladeWrapper.getItemTagCompound(par1ItemStack));
        switch (comboSec) {
            case Saya1: 
            case Saya2: {
                break;
            }
            default: {
                if (!ItemSlashBladeWrapper.hasWrapedItem(par1ItemStack)) break;
                try {
                    ItemStack wrapedItem = this.getWrapedItem(par1ItemStack);
                    int hurtRT = par2EntityLivingBase.field_70172_ad;
                    if (par3EntityLivingBase instanceof EntityPlayer) {
                        par2EntityLivingBase.field_70172_ad = par2EntityLivingBase.field_70771_an;
                        wrapedItem.func_77973_b().onLeftClickEntity(wrapedItem, (EntityPlayer)par3EntityLivingBase, (Entity)par2EntityLivingBase);
                    }
                    par2EntityLivingBase.field_70172_ad = 0;
                    wrapedItem.func_77973_b().func_77644_a(wrapedItem, par2EntityLivingBase, par3EntityLivingBase);
                    par2EntityLivingBase.field_70172_ad = hurtRT;
                    break;
                }
                catch (Throwable e) {
                    this.removeWrapItem(par1ItemStack);
                }
            }
        }
        return super.func_77644_a(par1ItemStack, par2EntityLivingBase, par3EntityLivingBase);
    }

    @Override
    public void setDamage(ItemStack stack, int damage) {
        NBTTagCompound tag = ItemSlashBladeWrapper.getItemTagCompound(stack);
        if (ItemSlashBladeWrapper.hasWrapedItem(stack)) {
            super.setDamage(stack, damage);
        } else {
            super.setDamage(stack, 0);
        }
        if (!TrueItemName.exists(tag)) {
            IsBroken.set(tag, false);
        }
    }

    @Override
    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        ItemStack wrapedItem;
        boolean result = super.func_82789_a(par1ItemStack, par2ItemStack);
        if (!result && !(wrapedItem = this.getWrapedItem(par1ItemStack)).func_190926_b()) {
            result = wrapedItem.func_77973_b().func_82789_a(wrapedItem, par2ItemStack);
        }
        return result;
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)new ItemStack((Item)this, 1, 0));
    }

    @Override
    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return !ItemSlashBladeWrapper.hasWrapedItem(stack);
    }
}

