/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.compat.enderio;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialeffect.SpecialEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class AnvilRecipe {
    Set<AnvilRecipeEntry> recipeEntries = Sets.newHashSet((Object[])new AnvilRecipeEntry[]{new AnvilRecipeEntry(new ResourceLocation("enderio", "itemMaterial"), 6, 0, 1), new AnvilRecipeEntry(new ResourceLocation("enderio", "itemBasicCapacitor"), 0, 1, 2), new AnvilRecipeEntry(new ResourceLocation("enderio", "itemBasicCapacitor"), 1, 2, 3), new AnvilRecipeEntry(new ResourceLocation("enderio", "itemBasicCapacitor"), 2, 3, 4)});

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onAnvil(AnvilUpdateEvent event) {
        AnvilRecipeEntry recipeEntry = null;
        for (AnvilRecipeEntry entry : this.recipeEntries) {
            if (!entry.matches(event)) continue;
            recipeEntry = entry;
            break;
        }
        if (recipeEntry == null) {
            return;
        }
        event.setMaterialCost(recipeEntry.getMaterialCost(event));
        event.setCost(recipeEntry.getLevelCost(event));
        event.setOutput(recipeEntry.getCraftingResult(event));
    }

    public static class AnvilRecipeEntry {
        ResourceLocation item;
        int meta;
        int targetLevel;
        int newLevel;

        public AnvilRecipeEntry(ResourceLocation item, int meta, int targetLevel, int newLevel) {
            this.item = item;
            this.meta = meta;
            this.targetLevel = targetLevel;
            this.newLevel = newLevel;
        }

        public boolean matches(AnvilUpdateEvent event) {
            if (!(event.getLeft().func_77973_b() instanceof ItemSlashBlade)) {
                return false;
            }
            if (event.getRight() == null) {
                return false;
            }
            Item rItem = event.getRight().func_77973_b();
            if (!rItem.getRegistryName().equals((Object)this.item)) {
                return false;
            }
            if (this.meta != event.getRight().func_77960_j()) {
                return false;
            }
            NBTTagCompound tag = ItemSlashBlade.getSpecialEffect(event.getLeft());
            int level = tag.func_74762_e(SpecialEffects.HFCustom.getEffectKey());
            return this.targetLevel == level;
        }

        @Nullable
        public ItemStack getCraftingResult(AnvilUpdateEvent event) {
            ItemStack result = event.getLeft().func_77946_l();
            SpecialEffects.addEffect(result, SpecialEffects.HFCustom.getEffectKey(), this.newLevel);
            return result;
        }

        public int getMaterialCost(AnvilUpdateEvent event) {
            return 1;
        }

        public int getLevelCost(AnvilUpdateEvent event) {
            return 5;
        }
    }
}

