/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityPhantomSwordBase
extends Entity
implements IProjectile,
IThrowableEntity {
    protected Entity thrower;
    protected ItemStack blade = null;
    protected List<Entity> alreadyHitEntity = new ArrayList<Entity>();
    protected float AttackLevel = 0.0f;
    static final int THROWER_ENTITY_ID = 11;
    float speed = 0.0f;
    float iniYaw = Float.NaN;
    float iniPitch = Float.NaN;
    double hitX;
    double hitY;
    double hitZ;
    float hitYaw;
    float hitPitch;
    public Entity ridingEntity2 = null;

    public EntityPhantomSwordBase(World par1World) {
        super(par1World);
        this.field_70145_X = true;
    }

    public EntityPhantomSwordBase(World par1World, EntityLivingBase entityLiving, float AttackLevel, float roll) {
        this(par1World, entityLiving, AttackLevel);
        this.setRoll(roll);
    }

    public EntityPhantomSwordBase(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        this(par1World);
        this.AttackLevel = AttackLevel;
        this.yOffset = entityLiving.func_70047_e() / 2.0f;
        this.setThrower((Entity)entityLiving);
        this.blade = entityLiving.getHeldItem();
        if (this.blade != null && !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            this.blade = null;
        }
        this.alreadyHitEntity.clear();
        this.alreadyHitEntity.add(this.thrower);
        this.alreadyHitEntity.add(this.thrower.field_184239_as);
        this.alreadyHitEntity.add(this.thrower.riddenByEntity);
        this.field_70173_aa = 0;
        this.func_70105_a(0.5f, 0.5f);
        float dist = 2.0f;
        double ran = ((double)this.field_70146_Z.nextFloat() - 0.5) * 2.0;
        double yaw = Math.toRadians(-this.thrower.field_70177_z + 90.0f);
        double x = ran * Math.sin(yaw);
        double y = 1.0 - Math.abs(ran);
        double z = ran * Math.cos(yaw);
        this.func_70012_b(this.thrower.field_70165_t + (x *= (double)dist), this.thrower.field_70163_u + (y *= (double)dist), this.thrower.field_70161_v + (z *= (double)dist), this.thrower.field_70177_z, this.thrower.field_70125_A);
        this.iniYaw = this.thrower.field_70177_z;
        this.iniPitch = this.thrower.field_70125_A;
        this.setDriveVector(1.75f);
    }

    protected void func_70088_a() {
        this.getDataWatcher().addObject(11, (Object)0);
        this.getDataWatcher().addObject(4, (Object)0);
        this.getDataWatcher().addObject(5, (Object)Float.valueOf(0.0f));
        this.getDataWatcher().addObject(6, (Object)20);
        this.getDataWatcher().addObject(7, (Object)7);
        this.getDataWatcher().addObject(10, (Object)0x3333FF);
    }

    public int getThrowerEntityId() {
        return this.getDataWatcher().getWatchableObjectInt(11);
    }

    public void setThrowerEntityId(int entityid) {
        this.getDataWatcher().updateObject(11, (Object)entityid);
    }

    public int getTargetEntityId() {
        return this.getDataWatcher().getWatchableObjectInt(4);
    }

    public void setTargetEntityId(int entityid) {
        this.getDataWatcher().updateObject(4, (Object)entityid);
    }

    public float getRoll() {
        return this.getDataWatcher().getWatchableObjectFloat(5);
    }

    public void setRoll(float roll) {
        this.getDataWatcher().updateObject(5, (Object)Float.valueOf(roll));
    }

    public int getLifeTime() {
        return this.getDataWatcher().getWatchableObjectInt(6);
    }

    public void setLifeTime(int lifetime) {
        this.getDataWatcher().updateObject(6, (Object)lifetime);
    }

    public int getInterval() {
        return this.getDataWatcher().getWatchableObjectInt(7);
    }

    public void setInterval(int value) {
        this.getDataWatcher().updateObject(7, (Object)value);
    }

    public int getColor() {
        return this.getDataWatcher().getWatchableObjectInt(10);
    }

    public void setColor(int value) {
        this.getDataWatcher().updateObject(10, (Object)value);
    }

    public boolean doTargeting() {
        Entity target;
        Entity rayEntity;
        if (this.field_70173_aa > this.getInterval()) {
            return false;
        }
        int targetid = this.getTargetEntityId();
        Entity owner = this.thrower;
        if (this.thrower == null) {
            owner = this;
        }
        if (targetid == 0 && (rayEntity = this.getRayTrace(owner, 30.0)) != null) {
            targetid = rayEntity.func_145782_y();
            this.setTargetEntityId(rayEntity.func_145782_y());
        }
        if (targetid == 0 && (rayEntity = this.getRayTrace(owner, 30.0, 5.0f, 5.0f)) != null) {
            targetid = rayEntity.func_145782_y();
            this.setTargetEntityId(rayEntity.func_145782_y());
        }
        if (targetid != 0 && (target = this.worldObj.func_73045_a(targetid)) != null) {
            if (Float.isNaN(this.iniPitch) && this.thrower != null) {
                this.iniYaw = this.thrower.field_70177_z;
                this.iniPitch = this.thrower.field_70125_A;
            }
            this.faceEntity(this, target, (float)this.field_70173_aa * 1.0f, (float)this.field_70173_aa * 1.0f);
            this.setDriveVector(1.75f, false);
        }
        return true;
    }

    public Entity getRayTrace(Entity owner, double reachMax) {
        return this.getRayTrace(owner, reachMax, 1.0f, 0.0f);
    }

    public Entity getRayTrace(Entity owner, double reachMax, float expandFactor, float expandBorder) {
        float par1 = 1.0f;
        MovingObjectPosition objectMouseOver = EntityPhantomSwordBase.rayTrace(owner, reachMax, par1);
        double reachMin = reachMax;
        Vec3 entityPos = EntityPhantomSwordBase.getPosition(owner);
        if (objectMouseOver != null) {
            reachMin = objectMouseOver.hitVec.distanceTo(entityPos);
        }
        Vec3 lookVec = EntityPhantomSwordBase.getLook(owner, par1);
        Vec3 reachVec = entityPos.addVector(lookVec.xCoord * reachMax, lookVec.yCoord * reachMax, lookVec.zCoord * reachMax);
        Entity pointedEntity = null;
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.field_70121_D.addCoord(lookVec.xCoord * reachMax, lookVec.yCoord * reachMax, lookVec.zCoord * reachMax).expand((double)expandFactor, (double)expandFactor, (double)expandFactor));
        list.removeAll(this.alreadyHitEntity);
        double tmpDistance = reachMin;
        EntityLivingBase viewer = owner instanceof EntityLivingBase ? (EntityLivingBase)owner : null;
        for (Entity entity : list) {
            double d3;
            if (entity == null || !entity.func_70067_L() || !ItemSlashBlade.AttackableSelector.isEntityApplicable(entity) || viewer != null && !viewer.func_70685_l(entity)) continue;
            float borderSize = entity.func_70111_Y() + expandBorder;
            AxisAlignedBB axisalignedbb = entity.field_70121_D.expand((double)borderSize, (double)borderSize, (double)borderSize);
            MovingObjectPosition movingobjectposition = axisalignedbb.calculateIntercept(entityPos, reachVec);
            if (axisalignedbb.isVecInside(entityPos)) {
                if (!(0.0 < tmpDistance) && tmpDistance != 0.0) continue;
                pointedEntity = entity;
                tmpDistance = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = entityPos.distanceTo(movingobjectposition.hitVec)) < tmpDistance) && tmpDistance != 0.0) continue;
            if (entity == this.field_184239_as && !entity.canRiderInteract()) {
                if (tmpDistance != 0.0) continue;
                pointedEntity = entity;
                continue;
            }
            pointedEntity = entity;
            tmpDistance = d3;
        }
        return pointedEntity;
    }

    public static MovingObjectPosition rayTrace(Entity owner, double par1, float par3) {
        Vec3 vec3 = EntityPhantomSwordBase.getPosition(owner);
        Vec3 vec31 = EntityPhantomSwordBase.getLook(owner, par3);
        Vec3 vec32 = vec3.addVector(vec31.xCoord * par1, vec31.yCoord * par1, vec31.zCoord * par1);
        return owner.worldObj.func_147447_a(vec3, vec32, false, false, true);
    }

    public static Vec3 getPosition(Entity owner) {
        return Vec3.createVectorHelper((double)owner.field_70165_t, (double)(owner.field_70163_u + (double)owner.func_70047_e()), (double)owner.field_70161_v);
    }

    public static Vec3 getLook(Entity owner, float rotMax) {
        if (rotMax == 1.0f) {
            float f1 = MathHelper.cos((float)(-owner.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = MathHelper.sin((float)(-owner.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = -MathHelper.cos((float)(-owner.field_70125_A * ((float)Math.PI / 180)));
            float f4 = MathHelper.sin((float)(-owner.field_70125_A * ((float)Math.PI / 180)));
            return Vec3.createVectorHelper((double)(f2 * f3), (double)f4, (double)(f1 * f3));
        }
        float f1 = owner.field_70127_C + (owner.field_70125_A - owner.field_70127_C) * rotMax;
        float f2 = owner.field_70126_B + (owner.field_70177_z - owner.field_70126_B) * rotMax;
        float f3 = MathHelper.cos((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.sin((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.cos((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.sin((float)(-f1 * ((float)Math.PI / 180)));
        return Vec3.createVectorHelper((double)(f4 * f5), (double)f6, (double)(f3 * f5));
    }

    public void faceEntity(Entity viewer, Entity target, float yawStep, float pitchStep) {
        double d2;
        double d0 = target.field_70165_t - viewer.field_70165_t;
        double d1 = target.field_70161_v - viewer.field_70161_v;
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)target;
            d2 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (viewer.field_70163_u + (double)viewer.func_70047_e());
        } else {
            d2 = (target.field_70121_D.minY + target.field_70121_D.maxY) / 2.0 - (viewer.field_70163_u + (double)viewer.func_70047_e());
        }
        double d3 = MathHelper.sqrt_double((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        this.iniPitch = this.updateRotation(this.iniPitch, f3, pitchStep);
        this.iniYaw = this.updateRotation(this.iniYaw, f2, yawStep);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.wrapAngleTo180_float((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    public void setDriveVector(float fYVecOfset) {
        this.setDriveVector(fYVecOfset, true);
    }

    public void setDriveVector(float fYVecOfst, boolean init) {
        float fYawDtoR = this.iniYaw / 180.0f * (float)Math.PI;
        float fPitDtoR = this.iniPitch / 180.0f * (float)Math.PI;
        this.field_70159_w = -MathHelper.sin((float)fYawDtoR) * MathHelper.cos((float)fPitDtoR) * fYVecOfst;
        this.field_70181_x = -MathHelper.sin((float)fPitDtoR) * fYVecOfst;
        this.field_70179_y = MathHelper.cos((float)fYawDtoR) * MathHelper.cos((float)fPitDtoR) * fYVecOfst;
        float f3 = MathHelper.sqrt_double((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / Math.PI);
        if (init) {
            this.speed = fYVecOfst;
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void func_70098_U() {
        Entity ridingEntity = this.ridingEntity2;
        if (ridingEntity.field_70128_L) {
            this.func_70106_y();
            return;
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70165_t = ridingEntity.field_70165_t + (this.hitX * Math.cos(Math.toRadians(ridingEntity.field_70177_z)) - this.hitZ * Math.sin(Math.toRadians(ridingEntity.field_70177_z)));
        this.field_70163_u = ridingEntity.field_70163_u + this.hitY;
        this.field_70161_v = ridingEntity.field_70161_v + (this.hitX * Math.sin(Math.toRadians(ridingEntity.field_70177_z)) + this.hitZ * Math.cos(Math.toRadians(ridingEntity.field_70177_z)));
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70125_A = ridingEntity.field_70125_A + this.hitPitch;
        this.field_70177_z = ridingEntity.field_70177_z + this.hitYaw;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.field_70173_aa >= 200) {
            if (!ridingEntity.field_70128_L && !this.worldObj.field_72995_K) {
                float magicDamage = Math.max(1.0f, this.AttackLevel / 2.0f);
                ridingEntity.field_70172_ad = 0;
                DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
                ridingEntity.func_70097_a(ds, magicDamage);
                if (this.blade != null && ridingEntity instanceof EntityLivingBase) {
                    if (this.thrower != null) {
                        StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.BreakPhantomSword);
                        ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)ridingEntity, (EntityLivingBase)this.thrower);
                    }
                    ridingEntity.field_70159_w = 0.0;
                    ridingEntity.field_70181_x = 0.0;
                    ridingEntity.field_70179_y = 0.0;
                    ridingEntity.func_70024_g(0.0, 0.1, 0.0);
                    ((EntityLivingBase)ridingEntity).field_70737_aN = 1;
                }
            }
            this.func_70106_y();
        }
    }

    protected void initRotation() {
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.sqrt_double((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
    }

    protected MovingObjectPosition getMovingObjectPosition() {
        IEntitySelector[] selectors;
        int z;
        int offset;
        int y;
        int x;
        Block block;
        Vec3 vec3 = Vec3.createVectorHelper((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 vec31 = Vec3.createVectorHelper((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition movingobjectposition = this.worldObj.rayTraceBlocks(vec3, vec31);
        vec3 = Vec3.createVectorHelper((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        vec31 = Vec3.createVectorHelper((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (movingobjectposition != null && (block = this.worldObj.getBlock(x = MathHelper.floor_double((double)movingobjectposition.hitVec.xCoord), (y = MathHelper.floor_double((double)movingobjectposition.hitVec.yCoord)) + (offset = -1), z = MathHelper.floor_double((double)movingobjectposition.hitVec.zCoord))) != null) {
            if (block.getCollisionBoundingBoxFromPool(this.worldObj, x, y + offset, z) == null) {
                movingobjectposition = null;
            } else {
                vec31 = Vec3.createVectorHelper((double)movingobjectposition.hitVec.xCoord, (double)movingobjectposition.hitVec.yCoord, (double)movingobjectposition.hitVec.zCoord);
            }
        }
        Entity entity = null;
        AxisAlignedBB bb = this.field_70121_D.addCoord(this.field_70159_w, this.field_70181_x, this.field_70179_y).expand(1.0, 1.0, 1.0);
        for (IEntitySelector selector : selectors = new IEntitySelector[]{ItemSlashBlade.DestructableSelector, ItemSlashBlade.AttackableSelector}) {
            Entity target;
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, bb, selector);
            list.removeAll(this.alreadyHitEntity);
            if (selector.equals(ItemSlashBlade.AttackableSelector) && this.getTargetEntityId() != 0 && (target = this.worldObj.func_73045_a(this.getTargetEntityId())) != null && target.field_70121_D.intersectsWith(bb)) {
                list.add(target);
            }
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                float f1;
                AxisAlignedBB axisalignedbb1;
                MovingObjectPosition movingobjectposition1;
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntityPhantomSwordBase && ((EntityPhantomSwordBase)entity1).getThrower() == this.getThrower() || !entity1.func_70067_L() || (movingobjectposition1 = (axisalignedbb1 = entity1.field_70121_D.expand((double)(f1 = 0.3f), (double)f1, (double)f1)).calculateIntercept(vec31, vec3)) == null || !((d1 = vec31.distanceTo(movingobjectposition1.hitVec)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity == null) continue;
            movingobjectposition = new MovingObjectPosition(entity);
            movingobjectposition.hitInfo = selector;
            break;
        }
        if (movingobjectposition != null && movingobjectposition.entityHit != null && movingobjectposition.entityHit instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.entityHit;
            if (entityplayer.field_71075_bZ.field_75102_a || this.getThrower() != null && this.getThrower() instanceof EntityPlayer && !((EntityPlayer)this.getThrower()).func_96122_a(entityplayer)) {
                movingobjectposition = null;
            }
        }
        return movingobjectposition;
    }

    public void doRotation() {
        if (this.doTargeting()) {
            return;
        }
        float f2 = MathHelper.sqrt_double((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
    }

    public void normalizeRotation() {
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    protected void destructEntity(Entity target) {
        if (this.thrower == null) {
            return;
        }
        StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.DestructObject);
        boolean isDestruction = true;
        if (target instanceof EntityFireball) {
            if (((EntityFireball)target).field_70235_a != null && ((EntityFireball)target).field_70235_a.func_145782_y() == this.thrower.func_145782_y()) {
                isDestruction = false;
            } else if (this.thrower instanceof EntityLivingBase) {
                isDestruction = !target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)this.thrower)), this.AttackLevel);
            }
        } else if (target instanceof EntityArrow) {
            if (((EntityArrow)target).field_70250_c != null && ((EntityArrow)target).field_70250_c.func_145782_y() == this.thrower.func_145782_y()) {
                isDestruction = false;
            }
        } else if (target instanceof EntityThrowable && ((EntityThrowable)target).func_85052_h() != null && ((EntityThrowable)target).func_85052_h().func_145782_y() == this.thrower.func_145782_y()) {
            isDestruction = false;
        }
        if (isDestruction && target instanceof IThrowableEntity && ((IThrowableEntity)target).getThrower() != null && ((IThrowableEntity)target).getThrower().func_145782_y() == this.thrower.func_145782_y()) {
            isDestruction = false;
        }
        if (isDestruction) {
            target.field_70159_w = 0.0;
            target.field_70181_x = 0.0;
            target.field_70179_y = 0.0;
            target.func_70106_y();
            for (int var1 = 0; var1 < 10; ++var1) {
                Random rand = this.getRand();
                double var2 = rand.nextGaussian() * 0.02;
                double var4 = rand.nextGaussian() * 0.02;
                double var6 = rand.nextGaussian() * 0.02;
                double var8 = 10.0;
                this.worldObj.spawnParticle("explode", target.field_70165_t + (double)(rand.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N - var2 * var8, target.field_70163_u + (double)(rand.nextFloat() * target.field_70131_O) - var4 * var8, target.field_70161_v + (double)(rand.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N - var6 * var8, var2, var4, var6);
            }
        }
        StylishRankManager.doAttack(this.thrower);
        this.func_70106_y();
    }

    protected void attackEntity(Entity target) {
        if (this.thrower != null) {
            this.thrower.getEntityData().func_74768_a("LastHitSummonedSwords", this.func_145782_y());
        }
        this.mountEntity(target);
        if (!this.worldObj.field_72995_K) {
            float magicDamage = Math.max(1.0f, this.AttackLevel);
            target.field_70172_ad = 0;
            DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
            target.func_70097_a(ds, magicDamage);
            if (this.blade != null && target instanceof EntityLivingBase && this.thrower != null && this.thrower instanceof EntityLivingBase) {
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.PhantomSword);
                ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)target, (EntityLivingBase)this.thrower);
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g(0.0, 0.1, 0.0);
                ((EntityLivingBase)target).field_70737_aN = 1;
                ((ItemSlashBlade)this.blade.func_77973_b()).setDaunting((EntityLivingBase)target);
            }
        }
    }

    protected void blastAttackEntity(Entity target) {
        if (!this.worldObj.field_72995_K) {
            float magicDamage = 1.0f;
            target.field_70172_ad = 0;
            DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
            target.func_70097_a(ds, magicDamage);
            if (this.blade != null && target instanceof EntityLivingBase && this.thrower != null && this.thrower instanceof EntityLivingBase) {
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.PhantomSword);
                ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)target, (EntityLivingBase)this.thrower);
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g(0.0, 0.1, 0.0);
                ((EntityLivingBase)target).field_70737_aN = 1;
                ((ItemSlashBlade)this.blade.func_77973_b()).setDaunting((EntityLivingBase)target);
            }
        }
    }

    protected boolean onImpact(MovingObjectPosition mop) {
        boolean result = true;
        if (mop.entityHit != null) {
            Entity target = mop.entityHit;
            if (mop.hitInfo.equals(ItemSlashBlade.AttackableSelector)) {
                this.attackEntity(target);
            } else {
                this.destructEntity(target);
            }
        } else if (!this.worldObj.getCollidingBoundingBoxes((Entity)this, this.field_70121_D).isEmpty()) {
            result = true;
        }
        return result;
    }

    public void spawnParticle() {
        if (this.func_70090_H()) {
            for (int l = 0; l < 4; ++l) {
                float trailLength = 0.25f;
                this.worldObj.spawnParticle("bubble", this.field_70165_t - this.field_70159_w * (double)trailLength, this.field_70163_u - this.field_70181_x * (double)trailLength, this.field_70161_v - this.field_70179_y * (double)trailLength, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
    }

    public void calculateSpeed() {
        float speedReductionFactor = 1.1f;
        if (this.func_70090_H()) {
            speedReductionFactor = 1.0f;
        }
        this.field_70159_w *= (double)speedReductionFactor;
        this.field_70181_x *= (double)speedReductionFactor;
        this.field_70179_y *= (double)speedReductionFactor;
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.ridingEntity2 != null) {
            this.func_70098_U();
        } else {
            if (this.field_70173_aa >= this.getLifeTime()) {
                this.func_70106_y();
            }
            this.initRotation();
            MovingObjectPosition movingobjectposition = this.getMovingObjectPosition();
            if (movingobjectposition != null && this.onImpact(movingobjectposition)) {
                return;
            }
            this.calculateSpeed();
            this.doRotation();
            if (this.getInterval() < this.field_70173_aa) {
                this.moveEntity(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            this.normalizeRotation();
            this.spawnParticle();
        }
    }

    public void func_70106_y() {
        if (this.thrower != null && this.thrower instanceof EntityPlayer) {
            ((EntityPlayer)this.thrower).func_71009_b((Entity)this);
        }
        this.worldObj.playSoundEffect(this.field_70169_q, this.field_70167_r, this.field_70166_s, "dig.glass", 0.25f, 1.6f);
        AxisAlignedBB bb = this.field_70121_D.expand(1.0, 1.0, 1.0);
        List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, bb, ItemSlashBlade.AttackableSelector);
        list.removeAll(this.alreadyHitEntity);
        for (Entity target : list) {
            if (target == null) continue;
            this.blastAttackEntity(target);
        }
        super.func_70106_y();
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_70038_c(double par1, double par3, double par5) {
        return false;
    }

    public void moveEntity(double par1, double par3, double par5) {
        super.moveEntity(par1, par3, par5);
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70055_a(Material par1Material) {
        return false;
    }

    public boolean handleLavaMovement() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.getBrightnessForRender(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float getBrightness(float par1) {
        float f1 = super.getBrightness(par1);
        float f2 = 0.9f;
        f2 = f2 * f2 * f2 * f2;
        return f1 * (1.0f - f2) + f2;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public Entity func_184187_bx() {
        return this.ridingEntity2;
    }

    public void mountEntity(Entity par1Entity) {
        if (par1Entity != null) {
            this.hitYaw = this.field_70177_z - par1Entity.field_70177_z;
            this.hitPitch = this.field_70125_A - par1Entity.field_70125_A;
            this.hitX = this.field_70165_t - par1Entity.field_70165_t;
            this.hitY = this.field_70163_u - par1Entity.field_70163_u;
            this.hitZ = this.field_70161_v - par1Entity.field_70161_v;
            this.ridingEntity2 = par1Entity;
            this.field_70173_aa = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public void setInPortal() {
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70110_aj() {
    }

    public void setThrowableHeading(double v, double v2, double v3, float v4, float v5) {
    }

    public Entity getThrower() {
        int id;
        if (this.thrower == null && (id = this.getThrowerEntityId()) != 0) {
            this.thrower = this.worldObj.func_73045_a(id);
        }
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        if (entity != null) {
            this.setThrowerEntityId(entity.func_145782_y());
        }
        this.thrower = entity;
    }
}

