/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.specialattack;

import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialattack.SpecialAttackBase;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Drive
extends SpecialAttackBase {
    private final float speed;
    private final int lifetime;
    private final boolean multihit;
    private final ItemSlashBlade.ComboSequence setCombo;
    private final String name;

    public Drive(String name, float speed, int lifetime, boolean multihit, ItemSlashBlade.ComboSequence setCombo) {
        this.name = name;
        this.speed = speed;
        this.lifetime = lifetime;
        this.multihit = multihit;
        this.setCombo = setCombo;
    }

    public Drive(float speed, int lifetime, boolean multihit, ItemSlashBlade.ComboSequence setCombo) {
        this("drive", speed, lifetime, multihit, setCombo);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public void doSpacialAttack(ItemStack stack, EntityPlayer player) {
        World world = player.field_70170_p;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(stack);
        if (!world.field_72995_K) {
            EntityDrive entityDrive;
            int cost = -10;
            if (!ItemSlashBlade.ProudSoul.tryAdd(tag, -10, false)) {
                ItemSlashBlade.damageItem(stack, 5, (EntityLivingBase)player);
            }
            ItemSlashBlade blade = (ItemSlashBlade)stack.func_77973_b();
            float baseModif = blade.getBaseAttackModifiers(tag);
            int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack);
            float magicDamage = baseModif;
            int rank = StylishRankManager.getStylishRank((Entity)player);
            if (5 <= rank) {
                magicDamage += ItemSlashBlade.AttackAmplifier.get(tag).floatValue() * (0.5f + (float)level / 5.0f);
            }
            if ((entityDrive = new EntityDrive(world, (EntityLivingBase)player, magicDamage, this.multihit, 90.0f - this.setCombo.swingDirection)) != null) {
                entityDrive.setInitialSpeed(this.speed);
                entityDrive.setLifeTime(this.lifetime);
                world.func_72838_d((Entity)entityDrive);
            }
        }
        player.func_184185_a(SoundEvents.field_187730_dW, 0.8f, 0.01f);
        ItemSlashBlade.setComboSequence(tag, this.setCombo);
    }
}

