/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;
import mods.flammpfeil.slashblade.ItemRendererBaseWeapon;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.ItemSlashBladeWrapper;
import mods.flammpfeil.slashblade.entity.EntityBladeStand;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

public class BladeStandRender
extends Render {
    public static IModelCustom standModel = null;
    public static ResourceLocation modelLocation = new ResourceLocation("flammpfeil.slashblade", "model/stand/stand.obj");
    public static ResourceLocation textureLocation = new ResourceLocation("flammpfeil.slashblade", "model/stand/stand.png");
    public static Map<EntityBladeStand.StandType, String> nameMap = BladeStandRender.createNameMap();
    public static Map<EntityBladeStand.StandType, String> StandTypeName = BladeStandRender.createStandTypeNameMap();

    private TextureManager engine() {
        return this.field_76990_c.field_78724_e;
    }

    private static <K, V> Map<K, V> createNameMap() {
        nameMap = Maps.newHashMap();
        nameMap.put(EntityBladeStand.StandType.Dual, "A");
        nameMap.put(EntityBladeStand.StandType.Single, "B");
        nameMap.put(EntityBladeStand.StandType.Upright, "C");
        nameMap.put(EntityBladeStand.StandType.Wall, "D");
        return nameMap;
    }

    private static <K, V> Map<K, V> createStandTypeNameMap() {
        StandTypeName = Maps.newHashMap();
        StandTypeName.put(EntityBladeStand.StandType.Dual, "dual");
        StandTypeName.put(EntityBladeStand.StandType.Single, "single");
        StandTypeName.put(EntityBladeStand.StandType.Upright, "upright");
        StandTypeName.put(EntityBladeStand.StandType.Wall, "wall");
        return StandTypeName;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialRenderTick) {
        ItemStack blade;
        if (standModel == null) {
            standModel = AdvancedModelLoader.loadModel((ResourceLocation)modelLocation);
        }
        this.func_110777_b(entity);
        EntityBladeStand e = (EntityBladeStand)entity;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        float scale = 0.00675f;
        EntityBladeStand.StandType type = EntityBladeStand.getType(e);
        boolean HFlip = false;
        boolean VFlip = false;
        switch (e.getFlip()) {
            case 1: {
                HFlip = false;
                VFlip = true;
                break;
            }
            case 2: {
                HFlip = true;
                VFlip = false;
                break;
            }
            case 3: {
                VFlip = true;
                HFlip = true;
                break;
            }
            default: {
                HFlip = false;
                VFlip = false;
            }
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)yaw, (float)0.0f, (float)-1.0f, (float)0.0f);
        if (type != EntityBladeStand.StandType.Naked) {
            GL11.glPushMatrix();
            if (type == EntityBladeStand.StandType.Wall) {
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
            }
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            String renderTarget = nameMap.get((Object)type);
            standModel.renderPart(renderTarget);
            GL11.glPopMatrix();
        }
        if ((blade = e.getBlade()) != null) {
            GL11.glPushMatrix();
            GL11.glShadeModel((int)7425);
            Item item = blade.func_77973_b();
            EnumSet<ItemSlashBlade.SwordType> types = ((ItemSlashBlade)item).getSwordType(blade);
            IModelCustom model = ItemRendererBaseWeapon.getModel(ItemSlashBlade.getModelLocation(blade));
            ResourceLocation resourceTexture = ItemSlashBlade.getModelTexture(blade);
            this.engine().func_110577_a(resourceTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glAlphaFunc((int)518, (float)0.05f);
            boolean isProcessed = false;
            if (model instanceof WavefrontObject) {
                WavefrontObject obj = (WavefrontObject)model;
                StringBuilder sb = new StringBuilder();
                sb.append("stand_");
                sb.append(StandTypeName.get((Object)type));
                if (types.contains((Object)ItemSlashBlade.SwordType.Broken)) {
                    sb.append("_damaged");
                }
                if (types.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) {
                    sb.append("_ns");
                }
                String targetBase = sb.toString();
                sb.append(HFlip ? "_r" : "_l");
                sb.append(VFlip ? "_u" : "_d");
                String targetFull = sb.toString();
                String renderTarget = null;
                for (GroupObject go : obj.groupObjects) {
                    if (!go.name.toLowerCase().equals(targetBase) && !go.name.toLowerCase().equals(targetFull)) continue;
                    renderTarget = go.name;
                    break;
                }
                if (renderTarget != null) {
                    GL11.glPushMatrix();
                    GL11.glScalef((float)scale, (float)scale, (float)scale);
                    model.renderPart(renderTarget);
                    GL11.glDisable((int)2896);
                    GL11.glEnable((int)3042);
                    float lastx = OpenGlHelper.lastBrightnessX;
                    float lasty = OpenGlHelper.lastBrightnessY;
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                    GL11.glBlendFunc((int)770, (int)1);
                    model.renderPart(renderTarget + "_luminous");
                    OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glEnable((int)2896);
                    GL11.glPopMatrix();
                    isProcessed = true;
                }
            }
            if (!(isProcessed || item instanceof ItemSlashBladeWrapper && !ItemSlashBladeWrapper.hasWrapedItem(blade))) {
                GL11.glPushMatrix();
                float hFlipFactor = HFlip ? -1.0f : 1.0f;
                switch (type) {
                    case Naked: {
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        if (!types.contains((Object)ItemSlashBlade.SwordType.Broken)) {
                            GL11.glTranslatef((float)0.0f, (float)200.0f, (float)0.0f);
                        } else {
                            GL11.glTranslatef((float)0.0f, (float)20.0f, (float)0.0f);
                        }
                        GL11.glRotatef((float)96.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        if (!VFlip) break;
                        GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
                        GL11.glRotatef((float)7.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case Dual: {
                        GL11.glTranslatef((float)(0.8f * hFlipFactor), (float)0.125f, (float)0.0f);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)(-3.5f * hFlipFactor), (float)0.0f, (float)0.0f, (float)1.0f);
                        if (!HFlip) break;
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case Wall: {
                        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.375f);
                    }
                    case Single: {
                        GL11.glTranslatef((float)(0.8f * hFlipFactor), (float)0.0f, (float)0.0f);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)(-3.5f * hFlipFactor), (float)0.0f, (float)0.0f, (float)1.0f);
                        if (HFlip) {
                            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        }
                        if (!VFlip) break;
                        GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
                        GL11.glRotatef((float)7.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        break;
                    }
                    case Upright: {
                        if (VFlip) {
                            GL11.glRotatef((float)2.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            GL11.glTranslatef((float)0.05f, (float)0.0f, (float)0.0f);
                        }
                        if (!HFlip) {
                            GL11.glScalef((float)scale, (float)scale, (float)scale);
                            GL11.glTranslatef((float)-17.277f, (float)235.96f, (float)0.0f);
                            GL11.glRotatef((float)96.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        } else {
                            GL11.glScalef((float)scale, (float)scale, (float)scale);
                            GL11.glTranslatef((float)27.597f, (float)-21.674f, (float)0.0f);
                            GL11.glRotatef((float)103.35f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        if (HFlip) {
                            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        }
                        if (!VFlip) break;
                        GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
                        GL11.glRotatef((float)7.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                }
                String renderTarget = types.contains((Object)ItemSlashBlade.SwordType.Broken) ? "blade_damaged" : "blade";
                model.renderPart(renderTarget);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                float lastx = OpenGlHelper.lastBrightnessX;
                float lasty = OpenGlHelper.lastBrightnessY;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GL11.glBlendFunc((int)770, (int)1);
                model.renderPart(renderTarget + "_luminous");
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glEnable((int)2896);
                GL11.glPopMatrix();
            }
            if (!isProcessed && !types.contains((Object)ItemSlashBlade.SwordType.NoScabbard)) {
                GL11.glPushMatrix();
                float hFlipFactor = HFlip ? -1.0f : 1.0f;
                float vFlipFactor = VFlip ? -1.0f : 1.0f;
                switch (type) {
                    case Naked: {
                        if (HFlip) {
                            GL11.glScalef((float)0.0f, (float)0.0f, (float)0.0f);
                        }
                        GL11.glTranslatef((float)1.5f, (float)-0.45f, (float)0.5f);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        if (!HFlip) break;
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case Dual: {
                        GL11.glTranslatef((float)(1.1f * hFlipFactor), (float)-0.17722f, (float)0.0f);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)(-3.5f * hFlipFactor), (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case Wall: {
                        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)-0.375f);
                    }
                    case Single: {
                        GL11.glTranslatef((float)(0.8f * hFlipFactor), (float)0.0f, (float)0.0f);
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glRotatef((float)(-3.5f * hFlipFactor), (float)0.0f, (float)0.0f, (float)1.0f);
                        break;
                    }
                    case Upright: {
                        if (VFlip) {
                            GL11.glRotatef((float)2.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            GL11.glTranslatef((float)0.05f, (float)0.0f, (float)0.0f);
                        }
                        if (!HFlip) {
                            GL11.glScalef((float)scale, (float)scale, (float)scale);
                            GL11.glTranslatef((float)-17.277f, (float)235.96f, (float)0.0f);
                            GL11.glRotatef((float)96.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            break;
                        }
                        GL11.glScalef((float)scale, (float)scale, (float)scale);
                        GL11.glTranslatef((float)27.597f, (float)-21.674f, (float)0.0f);
                        GL11.glRotatef((float)103.35f, (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                }
                if (HFlip) {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (VFlip) {
                    GL11.glTranslatef((float)0.0f, (float)15.0f, (float)0.0f);
                    GL11.glRotatef((float)7.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                String renderTarget = "sheath";
                model.renderPart(renderTarget);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                float lastx = OpenGlHelper.lastBrightnessX;
                float lasty = OpenGlHelper.lastBrightnessY;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GL11.glBlendFunc((int)770, (int)1);
                model.renderPart(renderTarget + "_luminous");
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastx, (float)lasty);
                GL11.glEnable((int)2896);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                GL11.glPopMatrix();
            }
            GL11.glShadeModel((int)7424);
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return textureLocation;
    }
}

