/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.ItemSlashBladeWrapper;
import mods.flammpfeil.slashblade.stats.AchievementList;
import mods.flammpfeil.slashblade.util.SlashBladeHooks;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityBladeStand
extends Entity {
    static final int WatchIndexFlipState = 10;
    static final int WatchIndexStandType = 9;
    static final int WatchIndexBlade = 8;
    static final String SaveKeyBlade = "Blade";
    static final String SaveKeyStandType = "StandType";
    static final String SaveKeyFlip = "Flip";

    public EntityBladeStand(World p_i1582_1_) {
        super(p_i1582_1_);
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityBladeStand(World p_i1582_1_, double x, double y, double z, ItemStack blade) {
        this(p_i1582_1_);
        this.setStandType(-1);
        this.func_70080_a(x, y, z, 180.0f * (this.field_70146_Z.nextFloat() * 2.0f - 1.0f), this.field_70125_A);
        this.setBlade(blade);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_82709_a(8, 5);
        this.field_70180_af.func_75682_a(9, (Object)0);
        this.field_70180_af.func_75682_a(10, (Object)0);
    }

    public int getFlip() {
        return this.field_70180_af.func_75679_c(10);
    }

    public void setFlip(int value) {
        if (this.hasBlade() && this.getBlade().func_77973_b() instanceof ItemSlashBladeWrapper && !ItemSlashBladeWrapper.hasWrapedItem(this.getBlade()) && 2 <= value) {
            value = 0;
        }
        this.field_70180_af.func_75692_b(10, (Object)value);
    }

    public void doFlip() {
        this.setFlip(Math.abs((this.getFlip() + 1) % 4));
    }

    public int getStandType() {
        return this.field_70180_af.func_75679_c(9);
    }

    public void setStandType(int value) {
        this.field_70180_af.func_75692_b(9, (Object)value);
    }

    public static StandType getType(EntityBladeStand e) {
        return StandType.getType(e.getStandType());
    }

    public ItemStack getBlade() {
        return this.field_70180_af.func_82710_f(8);
    }

    public void setBlade(ItemStack blade) {
        if (blade != null && blade.func_77973_b() instanceof ItemSlashBladeWrapper && !ItemSlashBladeWrapper.hasWrapedItem(blade) && 2 <= this.getFlip()) {
            this.setFlip(0);
        }
        if (blade != null && blade.func_77973_b() instanceof ItemSlashBlade) {
            NBTTagCompound nBTTagCompound = ItemSlashBlade.getItemTagCompound(blade);
        }
        this.field_70180_af.func_75692_b(8, (Object)blade);
    }

    public boolean hasBlade() {
        return this.getBlade() != null;
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        if (p_70037_1_.func_74764_b(SaveKeyStandType)) {
            int type = p_70037_1_.func_74762_e(SaveKeyStandType);
            this.setStandType(type);
        }
        if (p_70037_1_.func_74764_b(SaveKeyBlade)) {
            NBTTagCompound tag = p_70037_1_.func_74775_l(SaveKeyBlade);
            ItemStack blade = ItemStack.func_77949_a((NBTTagCompound)tag);
            this.setBlade(blade);
        }
        if (p_70037_1_.func_74764_b(SaveKeyFlip)) {
            int flip = p_70037_1_.func_74762_e(SaveKeyFlip);
            this.setFlip(flip);
        }
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        ItemStack blade = this.getBlade();
        if (blade != null) {
            NBTTagCompound tag = new NBTTagCompound();
            blade.func_77955_b(tag);
            p_70014_1_.func_74782_a(SaveKeyBlade, (NBTBase)tag);
        }
        int type = this.getStandType();
        p_70014_1_.func_74768_a(SaveKeyStandType, type);
        int flip = this.getFlip();
        p_70014_1_.func_74768_a(SaveKeyFlip, flip);
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (SlashBladeHooks.onBladeStandAttack(this, p_70097_1_, p_70097_2_)) {
            return false;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    public void func_70071_h_() {
        if (SlashBladeHooks.onEntityBladeStandUpdateHooks(this)) {
            return;
        }
        super.func_70071_h_();
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70181_x = EntityBladeStand.getType(this) == StandType.Wall ? 0.0 : (this.hasBlade() ? (this.field_70163_u > 0.0 ? -0.1 : (this.field_70163_u < -0.5 ? 1.0 : 0.0)) : -0.1);
        Block block = this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
        if (!block.isAir((IBlockAccess)this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) && block.func_149712_f(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) < 0.0f) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v);
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.hasBlade() && this.field_70163_u < -10.0) {
            this.func_70106_y();
        }
        if (EntityBladeStand.getType(this) == StandType.Naked && !this.hasBlade() && 200 < this.field_70173_aa) {
            this.func_70106_y();
        }
    }

    public boolean setStandBlade(Entity e) {
        if (e instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)e;
            ItemStack stack = p.func_70694_bm();
            if (stack == null && this.hasBlade()) {
                AchievementList.triggerCraftingAchievement(this.getBlade(), p);
                p.func_70062_b(0, this.getBlade());
                this.setBlade(null);
                if (EntityBladeStand.getType(this) == StandType.Naked) {
                    this.func_70106_y();
                }
                return true;
            }
            if (stack != null && stack.func_77973_b() instanceof ItemSlashBlade && !this.hasBlade()) {
                this.setBlade(stack);
                p.func_70062_b(0, null);
                return true;
            }
        }
        return false;
    }

    public boolean func_85031_j(Entity p_85031_1_) {
        if (this.setStandBlade(p_85031_1_)) {
            return true;
        }
        if (!this.hasBlade() && p_85031_1_.func_70093_af()) {
            if (!p_85031_1_.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return true;
        }
        return super.func_85031_j(p_85031_1_);
    }

    public boolean func_130002_c(EntityPlayer p_130002_1_) {
        if (p_130002_1_.func_70093_af()) {
            this.doFlip();
            return true;
        }
        if (this.setStandBlade((Entity)p_130002_1_)) {
            return true;
        }
        return super.func_130002_c(p_130002_1_);
    }

    protected boolean func_70041_e_() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public static enum StandType {
        Dual,
        Single,
        Upright,
        Naked,
        Wall;

        static Map<Integer, StandType> typeMap;

        public static StandType getType(int id) {
            if (typeMap.containsKey(id)) {
                return typeMap.get(id);
            }
            return Naked;
        }

        static {
            typeMap = Maps.newHashMap();
            typeMap.put(-1, Naked);
            typeMap.put(0, Dual);
            typeMap.put(1, Single);
            typeMap.put(2, Wall);
            typeMap.put(3, Upright);
        }
    }
}

