/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.entity.EntityPhantomSwordBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityBlisteringSwords
extends EntityPhantomSwordBase {
    private static final int HAS_FIRED = 12;
    private static final int IS_JUDGMENT = 13;

    public EntityBlisteringSwords(World par1World) {
        super(par1World);
        this.setInterval(0);
    }

    public EntityBlisteringSwords(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        super(par1World, entityLiving, AttackLevel);
    }

    public EntityBlisteringSwords(World par1World, EntityLivingBase entityLiving, float AttackLevel, float roll, int interval) {
        super(par1World, entityLiving, AttackLevel, roll);
        interval = Math.max(0, Math.min(interval, 7));
        this.setInterval(interval);
        this.faceEntityStandby();
        this.setDriveVector(1.75f, true);
        this.func_70078_a(this.getThrower());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
        this.func_70096_w().func_75682_a(13, (Object)0);
    }

    public boolean hasFired() {
        return this.func_70096_w().func_75683_a(12) != 0;
    }

    public void setHasFired(boolean hasFired) {
        this.func_70096_w().func_75692_b(12, (Object)((byte)(hasFired ? 1 : 0)));
    }

    public boolean isJudgement() {
        return this.func_70096_w().func_75683_a(13) != 0;
    }

    public void setIsJudgement(boolean isJudgement) {
        this.func_70096_w().func_75692_b(13, (Object)((byte)(isJudgement ? 1 : 0)));
    }

    public Vec3 getLook(Entity target) {
        float f1 = MathHelper.func_76134_b((float)(-target.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-target.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-target.field_70125_A * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-target.field_70125_A * ((float)Math.PI / 180)));
        return Vec3.func_72443_a((double)(f2 * f3), (double)f4, (double)(f1 * f3));
    }

    @Override
    public void func_70098_U() {
        long currentTime;
        long holdlimit;
        if (this.hasFired()) {
            if (this.ridingEntity2 == this.thrower) {
                Vec3 vec = this.getLook(this.ridingEntity2);
                this.ridingEntity2 = null;
                this.field_70173_aa = 0;
                if (this.field_70170_p.field_72995_K && vec != null) {
                    vec = vec.func_72432_b();
                    vec.field_72450_a *= -0.25;
                    vec.field_72448_b *= -0.25;
                    vec.field_72449_c *= -0.25;
                    vec = vec.func_72441_c(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
                    this.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
            } else {
                super.func_70098_U();
            }
            return;
        }
        Entity ridingEntity = this.ridingEntity2;
        if (ridingEntity.field_70128_L) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && (holdlimit = ridingEntity.getEntityData().func_74763_f("SB.BSHOLDLIMIT") + (long)this.getInterval()) < (currentTime = this.field_70170_p.func_82737_E())) {
            this.setHasFired(true);
            this.field_70170_p.func_72866_a((Entity)this, true);
            this.field_70173_aa = 0;
            this.field_70170_p.func_72908_a(this.field_70169_q, this.field_70167_r, this.field_70166_s, "mob.enderdragon.wings", 0.35f, 0.2f);
            return;
        }
        this.faceEntityStandby();
        this.doTargeting();
    }

    @Override
    protected void initRotation() {
        super.initRotation();
        if (this.ridingEntity2 == null && !this.hasFired() && this.getThrower() != null && this.field_70170_p.field_72995_K) {
            this.func_70078_a(this.getThrower());
        }
    }

    @Override
    public void spawnParticle() {
        super.spawnParticle();
        if (this.hasFired()) {
            for (int l = 0; l < 4; ++l) {
                float trailLength = 0.25f;
                this.field_70170_p.func_72869_a("portal", this.field_70165_t - this.field_70159_w * (double)trailLength, this.field_70163_u - this.field_70181_x * (double)trailLength, this.field_70161_v - this.field_70179_y * (double)trailLength, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
    }

    @Override
    protected boolean onImpact(MovingObjectPosition mop) {
        boolean result = false;
        if (mop.field_72308_g != null) {
            Entity target = mop.field_72308_g;
            if (mop.hitInfo.equals(ItemSlashBlade.DestructableSelector)) {
                this.destructEntity(target);
                return true;
            }
            if (this.getTargetEntityId() != 0 && target.func_145782_y() != this.getTargetEntityId()) {
                return result;
            }
            if (mop.hitInfo.equals(ItemSlashBlade.AttackableSelector)) {
                this.attackEntity(target);
                result = true;
            }
        } else {
            if (this.field_70173_aa < 10) {
                return false;
            }
            if (!this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty()) {
                if (this.getThrower() != null && this.getThrower() instanceof EntityPlayer) {
                    ((EntityPlayer)this.getThrower()).func_71009_b((Entity)this);
                }
                this.func_70106_y();
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean doTargeting() {
        int targetid = this.getTargetEntityId();
        if (targetid != 0) {
            Entity target = this.field_70170_p.func_73045_a(targetid);
            if (target != null) {
                if (Float.isNaN(this.iniPitch) && this.getThrower() != null) {
                    this.iniYaw = this.getThrower().field_70177_z;
                    this.iniPitch = this.getThrower().field_70125_A;
                }
                this.faceEntity(this, target, 10.0f, 10.0f);
                this.setDriveVector(1.75f, false);
            }
        } else if (!this.hasFired()) {
            if (Float.isNaN(this.iniPitch) && this.getThrower() != null) {
                this.iniYaw = this.getThrower().field_70177_z;
                this.iniPitch = this.getThrower().field_70125_A;
            }
            if (this.getThrower() != null) {
                this.faceEntityV(this.getThrower(), 10.0f, 10.0f);
            }
            this.setDriveVector(1.75f, false);
        }
        return true;
    }

    @Override
    protected void attackEntity(Entity target) {
        float health;
        if (target instanceof EntityLivingBase && this.isJudgement() && 0.0f < (health = ((EntityLivingBase)target).func_110143_aJ())) {
            this.AttackLevel /= 2.0f;
            health = Math.max(1.0f, health - this.AttackLevel);
            ((EntityLivingBase)target).func_70606_j(health);
        }
        super.attackEntity(target);
    }

    private void faceEntityStandby() {
        int interval = Math.max(0, Math.min(this.getInterval(), 7));
        float dist = 0.8f;
        int[][] pattern = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, -1, 2}, {-1, -1, 2}, {1, -2, 3}, {-1, -2, 3}};
        double yaw = Math.toRadians(-this.getThrower().field_70177_z + (float)(90 * pattern[interval][0]));
        double x = Math.sin(yaw);
        double y = (float)pattern[interval][1] * 0.25f;
        double z = Math.cos(yaw);
        x *= (double)dist + 0.15 * (double)pattern[interval][2];
        z *= (double)dist + 0.15 * (double)pattern[interval][2];
        Vec3 vec = this.getThrower().func_70040_Z();
        if (vec != null) {
            x -= vec.field_72450_a;
            y -= vec.field_72448_b;
            z -= vec.field_72449_c;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.getThrower().field_70165_t + x, this.getThrower().field_70163_u + (double)this.getThrower().func_70047_e() + y, this.getThrower().field_70161_v + z);
        } else {
            this.func_70107_b(this.getThrower().field_70165_t + x, this.getThrower().field_70163_u + y, this.getThrower().field_70161_v + z);
        }
        this.func_70101_b(-this.getThrower().field_70177_z, -this.getThrower().field_70125_A);
    }

    public void faceEntityV(Entity viewer, float yawStep, float pitchStep) {
        Vec3 lookVec = this.getLook(viewer);
        if (lookVec == null) {
            return;
        }
        double d0 = lookVec.field_72450_a;
        double d1 = lookVec.field_72449_c;
        double d2 = lookVec.field_72448_b;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        this.iniPitch = this.updateRotation(this.iniPitch, f3, pitchStep);
        this.iniYaw = this.updateRotation(this.iniYaw, f2, yawStep);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }
}

