/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.EntityPhantomSwordBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityHeavyRainSwords
extends EntityPhantomSwordBase {
    static final int stayTime = 10;
    private static final int INI_PITCH = 12;
    private static final int INI_YAW = 13;

    public EntityHeavyRainSwords(World par1World) {
        super(par1World);
    }

    public EntityHeavyRainSwords(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        super(par1World, entityLiving, AttackLevel);
    }

    public EntityHeavyRainSwords(World par1World, EntityLivingBase entityLiving, float AttackLevel, float roll, int interval, int targetId) {
        super(par1World, entityLiving, AttackLevel, roll);
        this.setInterval(10 + interval);
        this.setTargetEntityId(targetId);
        this.faceEntityStandby();
        this.setDriveVector(1.75f, true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)Float.valueOf(-90.0f));
        this.func_70096_w().func_75682_a(13, (Object)Float.valueOf(0.0f));
    }

    public float getIniPitch() {
        return this.func_70096_w().func_111145_d(12);
    }

    public void setIniPitch(float pitch) {
        this.func_70096_w().func_75692_b(12, (Object)Float.valueOf(pitch));
    }

    public float getIniYaw() {
        return this.func_70096_w().func_111145_d(13);
    }

    public void setIniYaw(float yaw) {
        this.func_70096_w().func_75692_b(13, (Object)Float.valueOf(yaw));
    }

    @Override
    protected boolean onImpact(MovingObjectPosition mop) {
        if (this.getInterval() < this.field_70173_aa) {
            return super.onImpact(mop);
        }
        return false;
    }

    @Override
    public void spawnParticle() {
        super.spawnParticle();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == this.getInterval()) {
            this.field_70170_p.func_72908_a(this.field_70169_q, this.field_70167_r, this.field_70166_s, "mob.blaze.hit", 0.4f, 2.0f);
        }
        if (this.field_70173_aa < this.getInterval() && this.ridingEntity2 == null) {
            float trailLength = 0.25f;
            this.field_70170_p.func_72869_a("portal", this.field_70165_t - this.field_70159_w * (double)trailLength, this.field_70163_u - this.field_70181_x * (double)trailLength, this.field_70161_v - this.field_70179_y * (double)trailLength, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    @Override
    public boolean doTargeting() {
        return false;
    }

    public Vec3 getLook(Entity target) {
        float f1 = MathHelper.func_76134_b((float)(-target.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-target.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-target.field_70125_A * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-target.field_70125_A * ((float)Math.PI / 180)));
        return Vec3.func_72443_a((double)(f2 * f3), (double)f4, (double)(f1 * f3));
    }

    private void faceEntityStandby() {
        Vec3 lookVec = this.getLook(this.getThrower());
        Entity target = null;
        if (this.getTargetEntityId() != 0) {
            target = this.field_70170_p.func_73045_a(this.getTargetEntityId());
        }
        Vec3 pos = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        if (target != null) {
            pos = pos.func_72441_c(target.field_70165_t, target.field_70163_u, target.field_70161_v);
        } else {
            pos = pos.func_72441_c(this.getThrower().field_70165_t, this.getThrower().field_70163_u, this.getThrower().field_70161_v);
            float len = 8.0f;
            pos = pos.func_72441_c(lookVec.field_72450_a * (double)len, 0.0, lookVec.field_72449_c * (double)len);
        }
        float areaSize = 10 < this.getInterval() ? 1.5f : 0.1f;
        pos = pos.func_72441_c((this.getRand().nextGaussian() - 0.5) * (double)areaSize, 8.0, (this.getRand().nextGaussian() - 0.5) * (double)areaSize);
        this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        this.func_70101_b(this.getRand().nextFloat() * 360.0f, (float)(90.0 + (this.getRand().nextGaussian() - 0.5) * 8.0));
        this.iniPitch = this.field_70125_A;
        this.setIniPitch(this.iniPitch);
        this.iniYaw = this.field_70177_z;
        this.setIniYaw(this.iniYaw);
    }

    @Override
    public void setDriveVector(float fYVecOfst, boolean init) {
        fYVecOfst = 0.8f;
        if (Float.isNaN(this.iniYaw)) {
            this.iniYaw = this.getIniYaw();
        }
        if (Float.isNaN(this.iniPitch)) {
            this.iniPitch = this.getIniPitch();
        }
        float fYawDtoR = this.iniYaw / 180.0f * (float)Math.PI;
        float fPitDtoR = this.iniPitch / 180.0f * (float)Math.PI;
        this.field_70159_w = -MathHelper.func_76126_a((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        this.field_70181_x = -MathHelper.func_76126_a((float)fPitDtoR) * fYVecOfst;
        this.field_70179_y = MathHelper.func_76134_b((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / Math.PI);
        if (init) {
            this.speed = fYVecOfst;
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    @Override
    protected void attackEntity(Entity target) {
        if (!this.field_70170_p.field_72995_K) {
            float magicDamage = Math.max(1.0f, this.AttackLevel);
            target.field_70172_ad = 0;
            DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
            target.func_70097_a(ds, magicDamage);
            if (this.blade != null && target instanceof EntityLivingBase && this.thrower != null && this.thrower instanceof EntityLivingBase) {
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.PhantomSword);
                ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)target, (EntityLivingBase)this.thrower);
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                target.func_70024_g(0.0, 0.1, 0.0);
                ((EntityLivingBase)target).field_70737_aN = 1;
                ((ItemSlashBlade)this.blade.func_77973_b()).setDaunting((EntityLivingBase)target);
                StunManager.setFreeze((EntityLivingBase)target, 20L);
            }
        }
        this.func_70078_a(target);
    }

    @Override
    protected void blastAttackEntity(Entity target) {
        super.blastAttackEntity(target);
        if (!this.field_70170_p.field_72995_K && target instanceof EntityLivingBase) {
            StunManager.setFreeze((EntityLivingBase)target, 20L);
        }
    }

    @Override
    public void func_70078_a(Entity par1Entity) {
        if (par1Entity != null) {
            this.hitYaw = this.field_70177_z - par1Entity.field_70177_z;
            this.hitPitch = this.field_70125_A - par1Entity.field_70125_A;
            this.hitX = this.field_70142_S - par1Entity.field_70165_t;
            this.hitY = this.field_70137_T - par1Entity.field_70163_u;
            this.hitZ = this.field_70136_U - par1Entity.field_70161_v;
            this.ridingEntity2 = par1Entity;
            this.field_70173_aa = 200 - (this.getLifeTime() - this.field_70173_aa);
        }
    }
}

