/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import mods.flammpfeil.slashblade.ItemSlashBlade;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.EntityPhantomSwordBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySpiralSwords
extends EntityPhantomSwordBase {
    private static final int HAS_FIRED = 12;
    private static final int ROT_OFFSET = 13;
    private static final int HOLDID = 14;
    static final int waitTime = 7;
    int life = 2;

    public EntitySpiralSwords(World par1World) {
        super(par1World);
        this.setInterval(0);
    }

    public EntitySpiralSwords(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        super(par1World, entityLiving, AttackLevel);
    }

    public EntitySpiralSwords(World par1World, EntityLivingBase entityLiving, float AttackLevel, float roll, float rotOffset) {
        super(par1World, entityLiving, AttackLevel, roll);
        this.setRotOffset(rotOffset);
        this.faceEntityStandby();
        this.setDriveVector(1.0f, true);
        this.func_70078_a(this.getThrower());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70096_w().func_75682_a(12, (Object)0);
        this.func_70096_w().func_75682_a(13, (Object)Float.valueOf(0.0f));
        this.func_70096_w().func_75682_a(14, (Object)0);
    }

    public boolean hasFired() {
        return this.func_70096_w().func_75683_a(12) != 0;
    }

    public void setHasFired(boolean hasFired) {
        this.func_70096_w().func_75692_b(12, (Object)((byte)(hasFired ? 1 : 0)));
    }

    public float getRotOffset() {
        return this.func_70096_w().func_111145_d(13);
    }

    public void setRotOffset(float rotOffset) {
        this.func_70096_w().func_75692_b(13, (Object)Float.valueOf(rotOffset));
    }

    public int getHoldId() {
        return this.func_70096_w().func_75679_c(14);
    }

    public void setHoldId(int id) {
        this.func_70096_w().func_75692_b(14, (Object)id);
    }

    @Override
    public void func_70098_U() {
        if (this.hasFired()) {
            if (this.ridingEntity2 == this.thrower) {
                this.ridingEntity2 = null;
            } else {
                super.func_70098_U();
            }
            return;
        }
        Entity ridingEntity = this.ridingEntity2;
        this.faceEntityStandby();
        if (ridingEntity.field_70128_L) {
            this.setInterval(this.field_70173_aa + 7);
            this.setLifeTime(this.field_70173_aa + 30);
            this.setHasFired(true);
            this.field_70170_p.func_72866_a((Entity)this, true);
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            long holdid = ridingEntity.getEntityData().func_74763_f("SB.SPHOLDID");
            if (holdid != (long)this.getHoldId()) {
                this.setInterval(this.field_70173_aa + 7);
                this.setLifeTime(this.field_70173_aa + 30);
                this.field_70170_p.func_72908_a(this.field_70169_q, this.field_70167_r, this.field_70166_s, "mob.enderdragon.wings", 0.35f, 0.2f);
                this.setHasFired(true);
                this.field_70170_p.func_72866_a((Entity)this, true);
                return;
            }
            if (this.getInterval() < this.field_70173_aa) {
                this.setHasFired(true);
                this.field_70170_p.func_72866_a((Entity)this, true);
                return;
            }
        }
        this.setMotionVector(1.0f, false);
        MovingObjectPosition movingobjectposition = this.getMovingObjectPosition();
        if (movingobjectposition != null && this.onImpact(movingobjectposition)) {
            return;
        }
        this.doTargeting();
    }

    @Override
    protected void initRotation() {
        super.initRotation();
        if (this.ridingEntity2 == null && !this.hasFired() && this.getThrower() != null && this.field_70170_p.field_72995_K) {
            this.func_70078_a(this.getThrower());
        }
    }

    @Override
    public void spawnParticle() {
        super.spawnParticle();
        if (this.hasFired()) {
            for (int l = 0; l < 4; ++l) {
                float trailLength = 0.25f;
                this.field_70170_p.func_72869_a("portal", this.field_70165_t - this.field_70159_w * (double)trailLength, this.field_70163_u - this.field_70181_x * (double)trailLength, this.field_70161_v - this.field_70179_y * (double)trailLength, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
        }
    }

    @Override
    protected boolean onImpact(MovingObjectPosition mop) {
        boolean result = false;
        if (mop.field_72308_g != null) {
            Entity target = mop.field_72308_g;
            if (mop.hitInfo.equals(ItemSlashBlade.DestructableSelector)) {
                this.destructEntity(target);
                return true;
            }
            if (mop.hitInfo.equals(ItemSlashBlade.AttackableSelector)) {
                this.attackEntity(target);
            }
        } else {
            if (this.field_70173_aa < this.getInterval()) {
                return false;
            }
            if (!this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty()) {
                if (this.getThrower() != null && this.getThrower() instanceof EntityPlayer) {
                    ((EntityPlayer)this.getThrower()).func_71009_b((Entity)this);
                }
                this.func_70106_y();
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean doTargeting() {
        return false;
    }

    private void faceEntityStandby() {
        int ticks = this.field_70173_aa;
        if (this.getInterval() - 7 < ticks) {
            ticks = this.getInterval() - 7;
        }
        double rotParTick = 9.0;
        double offset = this.getRotOffset();
        double degYaw = (double)ticks * rotParTick + offset;
        double yaw = Math.toRadians(degYaw);
        Vec3 pos = Vec3.func_72443_a((double)Math.sin(yaw), (double)(Math.sin(yaw + (double)ticks / 10.0) * (double)0.1f), (double)Math.cos(yaw));
        double scale = 1.5;
        pos.field_72450_a *= scale;
        pos.field_72448_b *= scale;
        pos.field_72449_c *= scale;
        if (this.getThrower() != null) {
            pos = pos.func_72441_c(this.getThrower().field_70165_t, this.getThrower().field_70163_u, this.getThrower().field_70161_v);
            pos = !this.field_70170_p.field_72995_K ? pos.func_72441_c(0.0, (double)this.getThrower().field_70131_O / 2.0, 0.0) : pos.func_72441_c(0.0, (double)(-this.getThrower().field_70131_O) / 3.0, 0.0);
        }
        this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        this.func_70101_b((float)(-degYaw), 0.0f);
    }

    public void setMotionVector(float fYVecOfst, boolean init) {
        float fYawDtoR = this.field_70177_z / 180.0f * (float)Math.PI;
        float fPitDtoR = this.field_70125_A / 180.0f * (float)Math.PI;
        this.field_70159_w = -MathHelper.func_76126_a((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        this.field_70181_x = -MathHelper.func_76126_a((float)fPitDtoR) * fYVecOfst;
        this.field_70179_y = MathHelper.func_76134_b((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / Math.PI);
        if (init) {
            this.speed = fYVecOfst;
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    @Override
    protected void attackEntity(Entity target) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 3 != 0) {
                return;
            }
            float magicDamage = Math.max(1.0f, this.AttackLevel);
            target.field_70172_ad = 0;
            DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
            target.func_70097_a(ds, magicDamage);
            if (this.blade != null && target instanceof EntityLivingBase && this.thrower != null && this.thrower instanceof EntityLivingBase) {
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.PhantomSword);
                ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)target, (EntityLivingBase)this.thrower);
                target.field_70159_w = 0.0;
                target.field_70181_x = 0.0;
                target.field_70179_y = 0.0;
                ((EntityLivingBase)target).field_70737_aN = 1;
                ((ItemSlashBlade)this.blade.func_77973_b()).setDaunting((EntityLivingBase)target);
            }
            if (--this.life <= 0) {
                this.func_70106_y();
            }
        }
    }
}

