/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.capability.fluid;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.yanny.ages.api.property.FacingProperty;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidPipeHandler
extends WorldSavedData {
    private static final int PIPE_CAPACITY = 100;
    private static final Set<Direction> DIRECTIONS = Sets.newHashSet((Object[])Direction.values());
    private final Map<BlockPos, LazyOptional<FluidTank>> PIPES = new HashMap<BlockPos, LazyOptional<FluidTank>>();
    private final Map<LazyOptional<FluidTank>, Set<BlockPos>> CAPABILITIES = new HashMap<LazyOptional<FluidTank>, Set<BlockPos>>();
    private static final String SAVE_DATA_ID = "ages_api_fluid_pipe_handler";
    private static final HashMap<World, FluidPipeHandler> INSTANCE = new HashMap();
    private final World world;

    private FluidPipeHandler(@Nonnull World world) {
        super(SAVE_DATA_ID);
        this.world = world;
    }

    @Nonnull
    public static FluidPipeHandler getInstance(@Nonnull World world) {
        if (world.field_72995_K) {
            throw new IllegalStateException("FluidPipeHandler is only server-side");
        }
        FluidPipeHandler handler = INSTANCE.get(world);
        if (handler == null) {
            handler = new FluidPipeHandler(world);
            INSTANCE.put(world, handler);
        }
        if (world instanceof ServerWorld) {
            ServerWorld server = (ServerWorld)world;
            server.func_217481_x().func_215752_a(() -> INSTANCE.get(world), SAVE_DATA_ID);
        }
        return handler;
    }

    public synchronized void register(@Nonnull BlockPos position) {
        if (position == BlockPos.field_177992_a || this.PIPES.containsKey(position)) {
            return;
        }
        this.registerPipe(position);
        this.func_76185_a();
    }

    public synchronized void remove(@Nonnull BlockPos position) {
        if (position == BlockPos.field_177992_a) {
            return;
        }
        this.removePipe(position);
        this.func_76185_a();
    }

    public synchronized void connectionChanged(@Nonnull BlockPos position1, @Nonnull BlockPos position2) {
        if (position1 == BlockPos.field_177992_a || position2 == BlockPos.field_177992_a) {
            return;
        }
        this.networkChanged(position1, position2);
        this.func_76185_a();
    }

    public void func_76184_a(@Nonnull CompoundNBT compoundNBT) {
        ListNBT capabilityList = compoundNBT.func_150295_c("capabilities", compoundNBT.func_74762_e("listType"));
        this.PIPES.clear();
        this.CAPABILITIES.clear();
        capabilityList.forEach(tag -> {
            if (tag instanceof CompoundNBT) {
                CompoundNBT compound = (CompoundNBT)tag;
                int capacity = compound.func_74762_e("capacity");
                FluidTank tank = new FluidTank(capacity);
                LazyOptional capability = LazyOptional.of(() -> tank);
                HashSet set = new HashSet();
                ListNBT pipeList = compound.func_150295_c("pipes", compound.func_74762_e("listType"));
                tank.readFromNBT(compound);
                pipeList.forEach(t -> {
                    if (t instanceof CompoundNBT) {
                        CompoundNBT c = (CompoundNBT)t;
                        int x = c.func_74762_e("x");
                        int y = c.func_74762_e("y");
                        int z = c.func_74762_e("z");
                        BlockPos pos = new BlockPos(x, y, z);
                        set.add(pos);
                        this.PIPES.put(pos, (LazyOptional<FluidTank>)capability);
                    }
                });
                this.CAPABILITIES.put((LazyOptional<FluidTank>)capability, set);
            }
        });
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT compoundNBT) {
        ListNBT list = new ListNBT();
        this.CAPABILITIES.forEach((capability, posSet) -> {
            CompoundNBT compound = new CompoundNBT();
            ListNBT set = new ListNBT();
            capability.ifPresent(tank -> {
                compound.func_74768_a("capacity", tank.getCapacity());
                tank.writeToNBT(compound);
            });
            posSet.forEach(pos -> {
                CompoundNBT c = new CompoundNBT();
                c.func_74768_a("x", pos.func_177958_n());
                c.func_74768_a("y", pos.func_177956_o());
                c.func_74768_a("z", pos.func_177952_p());
                set.add((Object)c);
            });
            compound.func_218657_a("pipes", (INBT)set);
            compound.func_74768_a("listType", set.func_150303_d());
            list.add((Object)compound);
        });
        compoundNBT.func_218657_a("capabilities", (INBT)list);
        compoundNBT.func_74768_a("listType", list.func_150303_d());
        return compoundNBT;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull BlockPos position) {
        if (this.PIPES.containsKey(position)) {
            this.func_76185_a();
            return this.PIPES.get(position).cast();
        }
        return LazyOptional.empty();
    }

    private void registerPipe(@Nonnull BlockPos position) {
        List<LazyOptional<FluidTank>> around = this.findNetworksAround(position);
        if (around.isEmpty()) {
            LazyOptional<FluidTank> capability = this.getNewCapability();
            this.PIPES.put(position, capability);
            this.CAPABILITIES.put(capability, Sets.newHashSet((Object[])new BlockPos[]{position}));
        } else if (around.size() == 1) {
            LazyOptional<FluidTank> capability = around.get(0);
            this.PIPES.put(position, capability);
            this.CAPABILITIES.get(capability).add(position);
            capability.ifPresent(tank -> tank.setCapacity(tank.getCapacity() + 100));
        } else {
            LinkedList toRemove = new LinkedList();
            LazyOptional<FluidTank> capability = around.remove(0);
            capability.ifPresent(tank -> around.forEach(c -> {
                if (c == capability) {
                    return;
                }
                c.ifPresent(t -> {
                    tank.setCapacity(tank.getCapacity() + t.getCapacity() + 100);
                    if (!t.isEmpty()) {
                        tank.fill(t.getFluid(), IFluidHandler.FluidAction.EXECUTE);
                    }
                });
                Set<BlockPos> posSet = this.CAPABILITIES.get(c);
                this.CAPABILITIES.get(capability).addAll(posSet);
                posSet.forEach(p -> this.PIPES.replace((BlockPos)p, capability));
                toRemove.add(c);
            }));
            this.PIPES.put(position, capability);
            this.CAPABILITIES.get(capability).add(position);
            toRemove.forEach(this.CAPABILITIES::remove);
        }
    }

    private void removePipe(@Nonnull BlockPos position) {
        Set<BlockPos> around = this.findPipesAround(position);
        if (around.size() == 0) {
            LazyOptional<FluidTank> capability = this.PIPES.remove(position);
            this.CAPABILITIES.remove(capability);
        } else if (around.size() == 1) {
            LazyOptional<FluidTank> capability = this.PIPES.remove(position);
            Set<BlockPos> set = this.CAPABILITIES.get(capability);
            capability.ifPresent(tank -> {
                if (!tank.isEmpty()) {
                    tank.drain(tank.getFluidAmount() / set.size(), IFluidHandler.FluidAction.EXECUTE);
                }
                tank.setCapacity(tank.getCapacity() - 100);
            });
            set.remove(position);
        } else {
            LazyOptional<FluidTank> capability = this.PIPES.remove(position);
            Set<BlockPos> set = this.CAPABILITIES.remove(capability);
            capability.ifPresent(tank -> {
                if (!tank.isEmpty()) {
                    tank.drain(tank.getFluidAmount() / set.size(), IFluidHandler.FluidAction.EXECUTE);
                }
                tank.setCapacity(tank.getCapacity() - 100);
            });
            this.recalculateNetwork(capability, around);
        }
    }

    private void recalculateNetwork(LazyOptional<FluidTank> capability, Set<BlockPos> around) {
        HashMap<BlockPos, Set> map = new HashMap<BlockPos, Set>();
        AtomicInteger oldCapacity = new AtomicInteger();
        AtomicReference oldFluid = new AtomicReference();
        capability.ifPresent(tank -> {
            oldCapacity.set(tank.getCapacity());
            oldFluid.set(tank.getFluid().copy());
        });
        int oldPipesCount = oldCapacity.get() / 100;
        around.forEach(posAround -> {
            HashSet<BlockPos> mapSet = new HashSet<BlockPos>();
            map.put((BlockPos)posAround, mapSet);
            this.searchBranch((BlockPos)posAround, (Set<BlockPos>)mapSet);
        });
        Map.Entry entry = map.entrySet().iterator().next();
        int pipesCount = ((Set)entry.getValue()).size();
        map.remove(entry.getKey());
        this.CAPABILITIES.put(capability, (Set<BlockPos>)entry.getValue());
        capability.ifPresent(tank -> {
            tank.setCapacity(pipesCount * 100);
            if (!((FluidStack)oldFluid.get()).isEmpty()) {
                tank.getFluid().setAmount(((FluidStack)oldFluid.get()).getAmount() / oldPipesCount * pipesCount);
            }
        });
        map.forEach((pos, set) -> {
            if (set.equals(entry.getValue())) {
                return;
            }
            LazyOptional<FluidTank> newCapability = this.getNewCapability();
            this.CAPABILITIES.put(newCapability, (Set<BlockPos>)set);
            set.forEach(p -> this.PIPES.replace((BlockPos)p, newCapability));
            int pCount = set.size();
            newCapability.ifPresent(tank -> {
                tank.setCapacity(pCount * 100);
                if (!((FluidStack)oldFluid.get()).isEmpty()) {
                    tank.setFluid((FluidStack)oldFluid.get());
                    tank.getFluid().setAmount(((FluidStack)oldFluid.get()).getAmount() / oldPipesCount * pCount);
                }
            });
        });
    }

    private void networkChanged(BlockPos position1, BlockPos position2) {
        LazyOptional<FluidTank> capability1 = this.PIPES.get(position1);
        LazyOptional<FluidTank> capability2 = this.PIPES.get(position2);
        HashSet<BlockPos> mapSet1 = new HashSet<BlockPos>();
        HashSet<BlockPos> mapSet2 = new HashSet<BlockPos>();
        if (capability1 == null || capability2 == null) {
            return;
        }
        this.searchBranch(position1, mapSet1);
        this.searchBranch(position2, mapSet2);
        if (mapSet1.equals(mapSet2) && capability1 != capability2) {
            Set<BlockPos> set2 = this.CAPABILITIES.remove(capability2);
            capability1.ifPresent(tank1 -> capability2.ifPresent(tank2 -> {
                tank1.setCapacity(tank1.getCapacity() + tank2.getCapacity());
                if (!tank1.getFluid().isEmpty() || !tank2.getFluid().isEmpty()) {
                    if (tank1.getFluid().isEmpty() && !tank2.getFluid().isEmpty()) {
                        tank1.setFluid(tank2.getFluid());
                    } else if (!tank1.getFluid().isEmpty() && !tank2.getFluid().isEmpty()) {
                        tank1.getFluid().setAmount(tank1.getFluidAmount() + tank2.getFluidAmount());
                    }
                }
            }));
            this.CAPABILITIES.get(capability1).addAll(set2);
            set2.forEach(pos -> this.PIPES.replace((BlockPos)pos, capability1));
        } else if (!mapSet1.equals(mapSet2) && capability1 == capability2) {
            LazyOptional<FluidTank> tmpCapability = this.getNewCapability();
            AtomicReference oldFluid = new AtomicReference();
            AtomicInteger oldCapacity = new AtomicInteger();
            capability1.ifPresent(tank1 -> {
                oldCapacity.set(tank1.getCapacity());
                oldFluid.set(tank1.getFluid());
                tank1.setCapacity(mapSet1.size() * 100);
                if (!tank1.getFluid().isEmpty()) {
                    tank1.getFluid().setAmount(((FluidStack)oldFluid.get()).getAmount() / oldCapacity.get() * (mapSet1.size() * 100));
                }
            });
            tmpCapability.ifPresent(tank2 -> {
                tank2.setCapacity(mapSet2.size() * 100);
                if (!((FluidStack)oldFluid.get()).isEmpty()) {
                    tank2.getFluid().setAmount(((FluidStack)oldFluid.get()).getAmount() / oldCapacity.get() * (mapSet2.size() * 100));
                }
            });
            this.CAPABILITIES.get(capability1).clear();
            this.CAPABILITIES.get(capability1).addAll(mapSet1);
            this.CAPABILITIES.put(tmpCapability, mapSet2);
            mapSet2.forEach(pos -> this.PIPES.replace((BlockPos)pos, tmpCapability));
        }
    }

    private void searchBranch(BlockPos pos, Set<BlockPos> map) {
        map.add(pos);
        this.findUniquePipesAround(pos, map).forEach(posAround -> this.searchBranch((BlockPos)posAround, map));
    }

    @Nonnull
    private LazyOptional<FluidTank> getNewCapability() {
        return LazyOptional.of(() -> new FluidTank(100)).cast();
    }

    @Nonnull
    private List<LazyOptional<FluidTank>> findNetworksAround(@Nonnull BlockPos pos) {
        return DIRECTIONS.stream().map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).filter(this.PIPES::containsKey).map(this.PIPES::get).distinct().collect(Collectors.toList());
    }

    @Nonnull
    private Set<BlockPos> findPipesAround(@Nonnull BlockPos pos) {
        return DIRECTIONS.stream().map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).filter(this.PIPES::containsKey).collect(Collectors.toSet());
    }

    private Set<BlockPos> findUniquePipesAround(@Nonnull BlockPos pos, @Nonnull Set<BlockPos> map) {
        return DIRECTIONS.stream().map(dir -> new Pair(dir, (Object)pos.func_177972_a(dir))).filter(pair -> this.PIPES.containsKey(pair.getSecond())).filter(pair -> !map.contains(pair.getSecond())).filter(pair -> {
            BlockState blockState = this.world.func_180495_p(pos);
            int state = (Integer)blockState.func_177229_b((IProperty)FacingProperty.FACING_TO_PROPERTY_MAP.get(pair.getFirst()));
            int facing = (Integer)this.world.func_180495_p((BlockPos)pair.getSecond()).func_177229_b((IProperty)FacingProperty.FACING_TO_PROPERTY_MAP.get(((Direction)pair.getFirst()).func_176734_d()));
            return !(state != 2 && state != 3 || facing != 2 && facing != 3);
        }).map(Pair::getSecond).collect(Collectors.toSet());
    }
}

