/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.items;

import com.google.common.collect.Sets;
import com.yanny.ages.api.items.AgesToolItem;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class AgesAxeItem
extends AgesToolItem {
    private static final Set<Block> EFFECTIVE_ON = (Set)AgesAxeItem.getPrivateValue(AxeItem.class, null, 0);
    private static final Map<Block, Block> BLOCK_STRIPPING_MAP = (Map)AgesAxeItem.getPrivateValue(AxeItem.class, null, 1);
    private static final Set<Material> EFFECTIVE_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151584_j, Material.field_151570_A});

    public AgesAxeItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, EFFECTIVE_ON, builder, true, true, true);
    }

    public boolean func_150897_b(BlockState blockIn) {
        int i = this.func_200891_e().func_200925_d();
        if (blockIn.getHarvestTool() == ToolType.AXE) {
            return i >= blockIn.getHarvestLevel();
        }
        return EFFECTIVE_MATERIALS.contains(blockIn.func_185904_a());
    }

    @Override
    public float func_150893_a(@Nonnull ItemStack stack, BlockState state) {
        return !EFFECTIVE_MATERIALS.contains(state.func_185904_a()) ? super.func_150893_a(stack, state) : this.efficiency + AgesAxeItem.getAdditionalEfficiency(stack);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = context.func_195995_a());
        Block block = BLOCK_STRIPPING_MAP.get(blockstate.func_177230_c());
        if (block != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, (BlockState)block.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockstate.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, playerEntity -> playerEntity.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

