/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.items;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.yanny.ages.api.items.AgesToolItem;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class AgesHoeItem
extends AgesToolItem {
    private static final Map<Block, BlockState> HOE_LOOKUP = (Map)AgesHoeItem.getPrivateValue(HoeItem.class, null, 1);

    public AgesHoeItem(IItemTier tier, float attackSpeedIn, Item.Properties builder) {
        super(0.0f, attackSpeedIn, tier, Sets.newHashSet(), builder, false, true, true);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockState blockstate;
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        int hook = ForgeEventFactory.onHoeUse((ItemUseContext)context);
        if (hook != 0) {
            return hook > 0 ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        if (context.func_196000_l() != Direction.DOWN && world.func_175623_d(blockpos.func_177984_a()) && (blockstate = HOE_LOOKUP.get(world.func_180495_p(blockpos).func_177230_c())) != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, playerEntity -> playerEntity.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            multimap.removeAll((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", 0.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)(this.attackSpeed + AgesHoeItem.getAdditionalAttackSpeed(stack)), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @Override
    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }
}

