/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.yanny.ages.api.manual.Align;
import com.yanny.ages.api.manual.IManual;
import com.yanny.ages.api.manual.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ConfigHolder {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Pair<String, Obj<?, ?>> TEXT = new Pair((Object)"text", new Obj<String, String>(String.class, String.class, "<UNSET>", false, s -> s, s -> true));
    public static final Pair<String, Obj<?, ?>> SCALE = new Pair((Object)"scale", new Obj<Float, Float>(Float.class, Float.class, Float.valueOf(1.0f), true, s -> s, s -> s.floatValue() != 0.0f));
    public static final Pair<String, Obj<?, ?>> COLOR = new Pair((Object)"color", new Obj<Integer, Integer>(Integer.class, Integer.class, -1, true, s -> s, s -> true));
    public static final Pair<String, Obj<?, ?>> WIDTH = new Pair((Object)"width", new Obj<Integer, Integer>(Integer.class, Integer.class, -1, true, s -> s, s -> true));
    public static final Pair<String, Obj<?, ?>> HEIGHT = new Pair((Object)"height", new Obj<Integer, Integer>(Integer.class, Integer.class, -1, true, s -> s, s -> true));
    public static final Pair<String, Obj<?, ?>> ITEM = new Pair((Object)"item", new Obj<String, ItemStack>(String.class, ItemStack.class, "minecraft:stone", false, s -> new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s))), s -> ForgeRegistries.ITEMS.getValue(new ResourceLocation(s)) != null));
    public static final Pair<String, Obj<?, ?>> IMG_WIDTH = new Pair((Object)"w", new Obj<Integer, Integer>(Integer.class, Integer.class, 16, false, s -> s, s -> s > 0));
    public static final Pair<String, Obj<?, ?>> IMG_HEIGHT = new Pair((Object)"h", new Obj<Integer, Integer>(Integer.class, Integer.class, 16, false, s -> s, s -> s > 0));
    public static final Pair<String, Obj<?, ?>> IMG_U = new Pair((Object)"u", new Obj<Integer, Integer>(Integer.class, Integer.class, 0, true, s -> s, s -> s >= 0));
    public static final Pair<String, Obj<?, ?>> IMG_V = new Pair((Object)"v", new Obj<Integer, Integer>(Integer.class, Integer.class, 0, true, s -> s, s -> s >= 0));
    public static final Pair<String, Obj<?, ?>> IMAGE = new Pair((Object)"image", new Obj<String, ResourceLocation>(String.class, ResourceLocation.class, "minecraft:textures/block/stone.png", false, ResourceLocation::new, s -> Minecraft.func_71410_x().func_195551_G().func_219533_b(new ResourceLocation(s))));
    public static final Pair<String, Obj<?, ?>> MARGIN_TOP = new Pair((Object)"margin_top", new Obj<Integer, Integer>(Integer.class, Integer.class, 0, true, s -> s, s -> s >= 0));
    public static final Pair<String, Obj<?, ?>> MARGIN_LEFT = new Pair((Object)"margin_left", new Obj<Integer, Integer>(Integer.class, Integer.class, 0, true, s -> s, s -> s >= 0));
    public static final Pair<String, Obj<?, ?>> MARGIN_LEFT_AUTO = new Pair((Object)"margin_left", new Obj<Integer, Integer>(Integer.class, Integer.class, -1, true, s -> s, s -> true));
    public static final Pair<String, Obj<?, ?>> MARGIN_BOTTOM = new Pair((Object)"margin_bottom", new Obj<Integer, Integer>(Integer.class, Integer.class, 0, true, s -> s, s -> s >= 0));
    public static final Pair<String, Obj<?, ?>> MARGIN_RIGHT = new Pair((Object)"margin_right", new Obj<Integer, Integer>(Integer.class, Integer.class, 0, true, s -> s, s -> s >= 0));
    public static final Pair<String, Obj<?, ?>> MARGIN_RIGHT_AUTO = new Pair((Object)"margin_right", new Obj<Integer, Integer>(Integer.class, Integer.class, -1, true, s -> s, s -> true));
    public static final Pair<String, Obj<?, ?>> ALIGN_CENTER = new Pair((Object)"align", new Obj<String, Align>(String.class, Align.class, "CENTER", true, Align::fromString, s -> Align.fromString(s) != null));
    public static final Pair<String, Obj<?, ?>> ALIGN_LEFT = new Pair((Object)"align", new Obj<String, Align>(String.class, Align.class, "LEFT", true, Align::fromString, s -> Align.fromString(s) != null));
    public static final Pair<String, Obj<?, ?>> JUSTIFY = new Pair((Object)"justify", new Obj<Boolean, Boolean>(Boolean.class, Boolean.class, false, true, s -> s, s -> true));
    public static final Pair<String, Obj<?, ?>> RECIPE = new Pair((Object)"recipe", new Obj<JsonArray, IRecipe[]>(JsonArray.class, IRecipe[].class, new JsonArray(), false, ConfigHolder::getRecipes, ConfigHolder::checkRecipes));
    public static final Pair<String, Obj<?, ?>> LIST = new Pair((Object)"list", new Obj<JsonArray, String[]>(JsonArray.class, String[].class, new JsonArray(), false, ConfigHolder::getList, ConfigHolder::checkList));
    public static final Pair<String, Obj<?, ?>> BULLET = new Pair((Object)"bullet", new Obj<String, String>(String.class, String.class, "\u2022", true, s -> s, s -> true));
    private final Map<String, Obj<?, ?>> objMap = new HashMap();
    private final Map<String, ?> values = new HashMap();

    @SafeVarargs
    ConfigHolder(Pair<String, Obj<?, ?>> ... types) {
        for (Pair<String, Obj<?, ?>> type : types) {
            this.objMap.put((String)type.getFirst(), (Obj<?, ?>)type.getSecond());
        }
    }

    void loadConfig(JsonObject object, IManual manual) {
        for (Map.Entry<String, Obj<?, ?>> entry : this.objMap.entrySet()) {
            Obj<?, ?> type = entry.getValue();
            String key = entry.getKey();
            this.values.put(key, Utils.get(((Obj)type).param, manual, object, key, ((Obj)type).defaultValue, ((Obj)type).optional));
        }
    }

    <T> T getValue(@Nonnull Pair<String, Obj<?, ?>> key) {
        Obj<?, ?> type = this.objMap.get(key.getFirst());
        Object s = this.values.get(key.getFirst());
        if (((Obj)type).param.isAssignableFrom(s.getClass())) {
            if (!type.checkValue(s)) {
                LOGGER.warn("Param type check failed! {}", s);
                new Exception().printStackTrace();
                return null;
            }
            Object result = type.getValue(s);
            if (((Obj)type).result.isAssignableFrom(result.getClass())) {
                return (T)result;
            }
            LOGGER.warn("Invalid result type, cannot convert {} to return type", (Object)((Obj)type).result.getCanonicalName());
            new Exception().printStackTrace();
        } else {
            LOGGER.warn("Invalid parameter type, cannot convert {} to {}", (Object)s.getClass().getCanonicalName(), (Object)((Obj)type).param.getCanonicalName());
            new Exception().printStackTrace();
        }
        return null;
    }

    private static boolean checkRecipes(JsonArray array) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        if (array.size() == 0) {
            LOGGER.warn("Empty recipe list");
            return false;
        }
        for (JsonElement element : array) {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                LOGGER.warn("List element not an string");
                return false;
            }
            IRecipe recipe = recipeManager.func_215367_a(new ResourceLocation(element.getAsString())).orElse(null);
            if (recipe != null) continue;
            LOGGER.warn("Recipe '{}' does not exists", (Object)element.getAsString());
            return false;
        }
        return array.size() > 0;
    }

    private static IRecipe<?>[] getRecipes(JsonArray array) {
        RecipeManager recipeManager = Minecraft.func_71410_x().field_71441_e.func_199532_z();
        IRecipe[] result = new IRecipe[array.size()];
        int i = 0;
        for (JsonElement element : array) {
            result[i++] = recipeManager.func_215367_a(new ResourceLocation(element.getAsString())).orElse(null);
        }
        return result;
    }

    private static boolean checkList(JsonArray array) {
        for (JsonElement element : array) {
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) continue;
            return false;
        }
        return true;
    }

    private static String[] getList(JsonArray array) {
        String[] result = new String[array.size()];
        int i = 0;
        for (JsonElement element : array) {
            result[i++] = element.getAsJsonPrimitive().getAsString();
        }
        return result;
    }

    static class Obj<T, R> {
        private final Class<T> param;
        private final Class<R> result;
        private final T defaultValue;
        private final boolean optional;
        private final Function<T, R> transform;
        private final Predicate<T> check;

        public Obj(Class<T> param, Class<R> result, T defaultValue, boolean optional, Function<T, R> transform, Predicate<T> check) {
            this.param = param;
            this.result = result;
            this.defaultValue = defaultValue;
            this.optional = optional;
            this.transform = transform;
            this.check = check;
        }

        R getValue(Object t) {
            return this.transform.apply(t);
        }

        boolean checkValue(Object t) {
            return this.check.test(t);
        }
    }
}

