/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.ages.api.manual.Align;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.fonts.Font;
import net.minecraft.client.gui.fonts.IGlyph;
import net.minecraft.client.gui.fonts.TexturedGlyph;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class CustomFontRenderer {
    private final FontRenderer fontRenderer;

    CustomFontRenderer(FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
    }

    void drawSplitString(String str, int x, int y, int wrapWidth, int textColor, Align align, boolean justify) {
        str = this.trimStringNewline(str);
        this.renderSplitString(str, x, y, wrapWidth, textColor, align, justify);
    }

    String trimStringNewline(String str) {
        try {
            Class[] argTypes = new Class[]{String.class};
            Method trim = ObfuscationReflectionHelper.findMethod(FontRenderer.class, (String)"func_78273_d", (Class[])argTypes);
            return (String)trim.invoke((Object)this.fontRenderer, str);
        }
        catch (IllegalAccessException | InvocationTargetException | ObfuscationReflectionHelper.UnableToFindMethodException e) {
            e.printStackTrace();
            return "";
        }
    }

    public int getWordWrappedHeight(String str, int maxLength) {
        return 9 * this.wrapFormattedStringToWidth(str, maxLength).size();
    }

    Font getFont() {
        try {
            Field f = ObfuscationReflectionHelper.findField(FontRenderer.class, (String)"field_211127_e");
            return (Font)f.get(this.fontRenderer);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    List<Link> analyseSplitStringLinks(String str, int x, int y, int width, Align align, boolean justify) {
        str = this.trimStringNewline(str);
        return this.analyseSplitString(str, x, y, width, align, justify);
    }

    @Nonnull
    private List<StringWidth> wrapFormattedStringToWidth(@Nonnull String str, int wrapWidth) {
        ArrayList<StringWidth> list = new ArrayList<StringWidth>();
        MutableBool bool = new MutableBool();
        String s = "";
        while (!str.isEmpty()) {
            Size i = this.sizeStringToWidth(str, wrapWidth, bool);
            if (str.length() <= i.count) {
                list.add(new StringWidth(str, i.size, false));
                return list;
            }
            String s1 = str.substring(0, i.count);
            char c0 = str.charAt(i.count);
            boolean flag = c0 == ' ' || c0 == '\n';
            str = TextFormatting.func_211164_a((String)s1) + str.substring(i.count + (flag ? 1 : 0));
            list.add(new StringWidth(s1, i.size, true));
            s = s + s1 + "\n";
        }
        return list;
    }

    @Nonnull
    private Size sizeStringToWidth(@Nonnull String str, int wrapWidth, MutableBool link) {
        int k;
        int i = Math.max(1, wrapWidth);
        int j = str.length();
        float f = 0.0f;
        float r = 0.0f;
        int l = -1;
        boolean flag = false;
        int linkPos = 0;
        boolean flag1 = true;
        for (k = 0; k < j; ++k) {
            char c0 = str.charAt(k);
            boolean wasSpace = false;
            switch (c0) {
                case '\n': {
                    --k;
                    break;
                }
                case ' ': {
                    l = k;
                    r = f;
                    wasSpace = true;
                }
                default: {
                    if (f != 0.0f) {
                        flag1 = false;
                    }
                    f += this.getCharWidth(c0);
                    if (!flag) break;
                    f += 1.0f;
                    break;
                }
                case '\u00a7': {
                    TextFormatting textformatting;
                    if (k >= j - 1) break;
                    if ((textformatting = TextFormatting.func_211165_a((char)str.charAt(++k))) == TextFormatting.BOLD) {
                        flag = true;
                    } else if (textformatting != null && textformatting.func_211166_f()) {
                        flag = false;
                    }
                    if (str.charAt(k) != 'p') break;
                    linkPos = k;
                    if (!link.valid) {
                        int s = 2;
                        link.valid = true;
                        while (k + s < str.length() && str.charAt(k + s) != ' ') {
                            ++s;
                        }
                        k += s;
                        break;
                    }
                    link.valid = false;
                }
            }
            if (c0 == '\n') {
                l = ++k;
                r = f;
                break;
            }
            if (!(f > (float)i)) continue;
            if (flag1) {
                ++k;
            }
            if (!wasSpace) break;
            f -= this.getCharWidth(' ');
            break;
        }
        if (l < linkPos) {
            link.valid = false;
        }
        return k != j && l != -1 && l < k ? new Size(l, r) : new Size(k, f);
    }

    public float getCharWidth(char character) {
        return character == '\u00a7' ? 0.0f : this.getFont().func_211184_b(character).func_223274_a_(false);
    }

    private void renderSplitString(String str, int x, int y, int wrapWidth, int textColor, Align align, boolean justify) {
        MutableBool link = new MutableBool();
        for (StringWidth s : this.wrapFormattedStringToWidth(str, wrapWidth)) {
            float f = x;
            if (this.fontRenderer.func_78260_a()) {
                int i = this.fontRenderer.func_78256_a(this.fontRenderer.func_147647_b(s.str));
                f += (float)(wrapWidth - i);
            }
            if (justify && s.fullLine) {
                this.renderString(s.str, f, y, textColor, false, link, (float)wrapWidth - s.width);
            } else {
                switch (align) {
                    case LEFT: {
                        this.renderString(s.str, f, y, textColor, false, link, 0.0f);
                        break;
                    }
                    case RIGHT: {
                        this.renderString(s.str, f + ((float)wrapWidth - s.width), y, textColor, false, link, 0.0f);
                        break;
                    }
                    case CENTER: {
                        this.renderString(s.str, f + ((float)wrapWidth - s.width) / 2.0f, y, textColor, false, link, 0.0f);
                    }
                }
            }
            this.fontRenderer.getClass();
            y += 9;
        }
    }

    private int renderString(String text, float x, float y, int color, boolean dropShadow, MutableBool bool, float width) {
        if (text == null) {
            return 0;
        }
        if (this.fontRenderer.func_78260_a()) {
            text = this.fontRenderer.func_147647_b(text);
        }
        if ((color & 0xFC000000) == 0) {
            color |= 0xFF000000;
        }
        if (dropShadow) {
            this.renderStringAtPos(text, x, y, color, true, bool, width);
        }
        x = this.renderStringAtPos(text, x, y, color, false, bool, width);
        return (int)x + (dropShadow ? 1 : 0);
    }

    private float renderStringAtPos(@Nonnull String text, float x, float y, int color, boolean isShadow, MutableBool link, float width) {
        float f = isShadow ? 0.25f : 1.0f;
        float f1 = (float)(color >> 16 & 0xFF) / 255.0f * f;
        float f2 = (float)(color >> 8 & 0xFF) / 255.0f * f;
        float f3 = (float)(color & 0xFF) / 255.0f * f;
        float f4 = f1;
        float f5 = f2;
        float f6 = f3;
        float f7 = (float)(color >> 24 & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        ResourceLocation resourcelocation = null;
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        boolean flag = false;
        boolean flag1 = false;
        boolean flag2 = false;
        boolean flag3 = false;
        boolean flag4 = false;
        ArrayList list = Lists.newArrayList();
        int spaces = this.getSpaces(text);
        float spaceWidth = 0.0f;
        if (width > 0.0f && spaces > 0) {
            spaceWidth = width / (float)spaces;
        }
        for (int i = 0; i < text.length(); ++i) {
            float f11;
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i + 1 < text.length()) {
                TextFormatting textformatting = TextFormatting.func_211165_a((char)text.charAt(i + 1));
                if (textformatting != null) {
                    if (textformatting.func_211166_f()) {
                        flag = false;
                        flag1 = false;
                        flag4 = false;
                        flag3 = false;
                        flag2 = false;
                        f4 = f1;
                        f5 = f2;
                        f6 = f3;
                    }
                    if (textformatting.func_211163_e() != null) {
                        int j = textformatting.func_211163_e();
                        f4 = (float)(j >> 16 & 0xFF) / 255.0f * f;
                        f5 = (float)(j >> 8 & 0xFF) / 255.0f * f;
                        f6 = (float)(j & 0xFF) / 255.0f * f;
                    } else if (textformatting == TextFormatting.OBFUSCATED) {
                        flag = true;
                    } else if (textformatting == TextFormatting.BOLD) {
                        flag1 = true;
                    } else if (textformatting == TextFormatting.STRIKETHROUGH) {
                        flag4 = true;
                    } else if (textformatting == TextFormatting.UNDERLINE) {
                        flag3 = true;
                    } else if (textformatting == TextFormatting.ITALIC) {
                        flag2 = true;
                    }
                } else if (text.charAt(i + 1) == 'p') {
                    if (!link.valid) {
                        int j = 2;
                        link.valid = true;
                        while (i + j < text.length() && text.charAt(i + j) != ' ') {
                            ++j;
                        }
                        i += j - 1;
                    } else {
                        link.valid = false;
                    }
                }
                ++i;
                continue;
            }
            IGlyph iglyph = this.getFont().func_211184_b(c0);
            TexturedGlyph texturedglyph = flag && c0 != ' ' ? this.getFont().func_211188_a(iglyph) : this.getFont().func_211187_a(c0);
            ResourceLocation resourcelocation1 = texturedglyph.func_211233_b();
            if (resourcelocation1 != null) {
                if (resourcelocation != resourcelocation1) {
                    tessellator.func_78381_a();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(resourcelocation1);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    resourcelocation = resourcelocation1;
                }
                float f8 = flag1 ? iglyph.func_223275_b_() : 0.0f;
                float f9 = isShadow ? iglyph.func_223276_c_() : 0.0f;
                this.renderGlyph(texturedglyph, flag1, flag2, f8, x + f9, y + f9, bufferbuilder, f4, f5, f6, f7);
            }
            float f10 = iglyph.func_223274_a_(flag1);
            float f8 = f11 = isShadow ? 1.0f : 0.0f;
            if (flag4) {
                list.add(new Entry(x + f11 - 1.0f, y + f11 + 4.5f, x + f11 + f10, y + f11 + 4.5f - 1.0f, f4, f5, f6, f7));
            }
            if (flag3) {
                list.add(new Entry(x + f11 - 1.0f, y + f11 + 9.0f, x + f11 + f10, y + f11 + 9.0f - 1.0f, f4, f5, f6, f7));
            }
            x += f10;
            if (!(spaceWidth > 0.0f) || c0 != ' ') continue;
            x += spaceWidth;
        }
        tessellator.func_78381_a();
        if (!list.isEmpty()) {
            GlStateManager.disableTexture();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            for (Entry fontrenderer$entry : list) {
                fontrenderer$entry.pipe(bufferbuilder);
            }
            tessellator.func_78381_a();
            GlStateManager.enableTexture();
        }
        return x;
    }

    private int getSpaces(String text) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                ++count;
                continue;
            }
            if (c != '\u00a7' || i >= text.length() - 1 || text.charAt(i + 1) != 'p') continue;
            --count;
        }
        return count;
    }

    private void renderGlyph(@Nonnull TexturedGlyph glyph, boolean bold, boolean italic, float boldOffset, float x, float y, BufferBuilder builder, float r, float g, float b, float a) {
        glyph.func_211234_a(Minecraft.func_71410_x().field_71446_o, italic, x, y, builder, r, g, b, a);
        if (bold) {
            glyph.func_211234_a(Minecraft.func_71410_x().field_71446_o, italic, x + boldOffset, y, builder, r, g, b, a);
        }
    }

    @Nonnull
    private List<Link> analyseSplitString(String str, int x, int y, int width, Align align, boolean justify) {
        ArrayList<Link> list = new ArrayList<Link>();
        int line = 0;
        for (StringWidth s : this.wrapFormattedStringToWidth(str, width)) {
            if (justify && s.fullLine) {
                this.analyseString(list, s.str, x, y, line, (float)width - s.width);
            } else {
                switch (align) {
                    case LEFT: {
                        this.analyseString(list, s.str, x, y, line, 0.0f);
                        break;
                    }
                    case RIGHT: {
                        this.analyseString(list, s.str, (float)x + ((float)width - s.width), y, line, 0.0f);
                        break;
                    }
                    case CENTER: {
                        this.analyseString(list, s.str, (float)x + ((float)width - s.width) / 2.0f, y, line, 0.0f);
                    }
                }
            }
            double d = y;
            this.fontRenderer.getClass();
            y = (int)(d + Math.ceil(9.0));
            ++line;
        }
        return list;
    }

    private void analyseString(List<Link> list, String text, float x, float y, int line, float width) {
        if (text != null) {
            this.analyseStringAtPos(list, text, x, y, line, width);
        }
    }

    private void analyseStringAtPos(List<Link> list, @Nonnull String text, float xIn, float yIn, int line, float width) {
        boolean bold = false;
        float x = xIn;
        int spaces = this.getSpaces(text);
        float spaceWidth = 0.0f;
        if (width > 0.0f && spaces > 0) {
            spaceWidth = width / (float)spaces;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i + 1 < text.length()) {
                TextFormatting textformatting = TextFormatting.func_211165_a((char)text.charAt(i + 1));
                if (textformatting != null) {
                    if (textformatting.func_211166_f()) {
                        bold = false;
                    }
                    if (textformatting == TextFormatting.BOLD) {
                        bold = true;
                    }
                } else if (text.charAt(i + 1) == 'p') {
                    Rect rect;
                    Link link = list.isEmpty() ? new Link() : list.get(list.size() - 1);
                    if (link.rects.isEmpty() || link.rects.get((int)(link.rects.size() - 1)).valid) {
                        rect = new Rect();
                        rect.x1 = x;
                        rect.y1 = yIn;
                        rect.line = line;
                        link = new Link();
                        link.rects.add(rect);
                        list.add(link);
                        StringBuilder sb = new StringBuilder();
                        int j = 2;
                        while (i + j < text.length() && text.charAt(i + j) != ' ') {
                            sb.append(text.charAt(i + j));
                            ++j;
                        }
                        link.key = sb.toString();
                        i += j - 1;
                    } else {
                        rect = link.rects.get(link.rects.size() - 1);
                        rect.x2 = x;
                        this.fontRenderer.getClass();
                        rect.y2 = yIn + 9.0f;
                        rect.valid = true;
                        rect.line = line;
                    }
                }
                ++i;
                continue;
            }
            IGlyph iglyph = this.getFont().func_211184_b(c0);
            float f10 = iglyph.func_223274_a_(bold);
            x += f10;
            if (!(spaceWidth > 0.0f) || c0 != ' ') continue;
            x += spaceWidth;
        }
        if (!list.isEmpty() && list.get(list.size() - 1).hasUnclosedLink()) {
            Link link = list.get(list.size() - 1);
            Rect rect = link.rects.get(link.rects.size() - 1);
            if (rect.line != line) {
                rect.x1 = xIn;
                rect.y1 = yIn;
            }
            rect.x2 = x;
            this.fontRenderer.getClass();
            rect.y2 = yIn + 9.0f;
            rect.valid = true;
            Rect newLine = new Rect();
            newLine.x1 = xIn;
            newLine.y1 = rect.y2;
            link.rects.add(newLine);
        }
    }

    static class Size {
        final int count;
        final float size;

        Size(int count, float size) {
            this.count = count;
            this.size = size;
        }
    }

    static class StringWidth {
        String str;
        float width;
        boolean fullLine;

        StringWidth(String str, float width, boolean fullLine) {
            this.str = str;
            this.width = width;
            this.fullLine = fullLine;
        }
    }

    static class MutableBool {
        boolean valid;

        MutableBool() {
        }
    }

    static class Entry {
        protected final float x1;
        protected final float y1;
        protected final float x2;
        protected final float y2;
        protected final float red;
        protected final float green;
        protected final float blue;
        protected final float alpha;

        private Entry(float x1, float y1, float x2, float y2, float red, float green, float blue, float alpha) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
        }

        public void pipe(@Nonnull BufferBuilder buffer) {
            buffer.func_181662_b((double)this.x1, (double)this.y1, 0.0).func_181666_a(this.red, this.green, this.blue, this.alpha).func_181675_d();
            buffer.func_181662_b((double)this.x2, (double)this.y1, 0.0).func_181666_a(this.red, this.green, this.blue, this.alpha).func_181675_d();
            buffer.func_181662_b((double)this.x2, (double)this.y2, 0.0).func_181666_a(this.red, this.green, this.blue, this.alpha).func_181675_d();
            buffer.func_181662_b((double)this.x1, (double)this.y2, 0.0).func_181666_a(this.red, this.green, this.blue, this.alpha).func_181675_d();
        }
    }

    static class Rect {
        boolean valid;
        int line;
        float x1;
        float x2;
        float y1;
        float y2;

        Rect() {
        }

        boolean inArea(int mx, int my, float scale) {
            return (float)mx >= this.x1 * scale && (float)mx < this.x2 * scale && (float)my >= this.y1 * scale && (float)my < this.y2 * scale;
        }
    }

    static class Link {
        final List<Rect> rects = new ArrayList<Rect>();
        String key;

        Link() {
        }

        boolean hasUnclosedLink() {
            return !this.rects.isEmpty() && !this.rects.get((int)(this.rects.size() - 1)).valid;
        }

        boolean inArea(int mx, int my, float scale) {
            return this.rects.stream().anyMatch(rect -> rect.inArea(mx, my, scale));
        }
    }
}

