/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.yanny.ages.api.manual.ConfigHolder;
import com.yanny.ages.api.manual.ConfigurableWidget;
import com.yanny.ages.api.manual.IManual;
import com.yanny.ages.api.manual.Utils;
import com.yanny.ages.api.manual.Widget;
import com.yanny.ages.api.manual.WidgetFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HorizontalLayoutWidget
extends ConfigurableWidget {
    public static final String TYPE = "hlayout";
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final int margin_right = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_RIGHT);
    private final int margin_left = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_LEFT);
    private final int margin_top = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_TOP);
    private final int margin_bottom = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_BOTTOM);

    HorizontalLayoutWidget(JsonObject object, IManual manual) {
        super(object, manual, ConfigHolder.MARGIN_LEFT, ConfigHolder.MARGIN_RIGHT, ConfigHolder.MARGIN_TOP, ConfigHolder.MARGIN_BOTTOM);
        JsonArray array = Utils.getArray(object, "content");
        if (array == null) {
            return;
        }
        for (JsonElement element : array) {
            if (!element.isJsonObject()) {
                LOGGER.warn("Element {} is not an object", (Object)element.toString());
                continue;
            }
            JsonObject obj = element.getAsJsonObject();
            String type = (String)Utils.get(String.class, manual, obj, "type", null, false);
            if (type == null) continue;
            Widget widget = WidgetFactory.getWidget(type, obj, manual);
            this.widgets.add(widget);
        }
    }

    @Override
    public void drawBackgroundLayer(Screen screen, int mx, int my) {
        this.widgets.forEach(widget -> {
            if (widget.visible) {
                widget.drawBackgroundLayer(screen, mx, my);
            }
        });
    }

    @Override
    public void render(Screen screen, int mx, int my) {
        this.widgets.forEach(widget -> {
            if (widget.visible) {
                widget.render(screen, mx, my);
            }
        });
    }

    @Override
    public void setPos(int x, int y) {
        super.setPos(x, y);
        int pos = x + this.margin_left;
        int oldWidth = this.getWidth();
        this.setWidth(oldWidth - this.margin_left - this.margin_right);
        Utils.resizeHLayout(this, this.widgets);
        this.setWidth(oldWidth);
        for (Widget widget : this.widgets) {
            widget.setPos(pos, y + this.margin_top);
            pos += widget.getWidth();
        }
    }

    @Override
    public int getMinHeight(int width) {
        int height = -1;
        int totalWidth = 0;
        int oldWidth = this.getWidth();
        this.setWidth(width);
        Utils.resizeHLayout(this, this.widgets);
        this.setWidth(oldWidth);
        for (Widget widget : this.widgets) {
            height = Math.max(height, widget.getMinHeight(width - totalWidth));
            totalWidth += widget.getWidth();
        }
        return height + this.margin_top + this.margin_bottom;
    }

    @Override
    public boolean mouseClicked(int mx, int my, int key) {
        for (Widget widget : this.widgets) {
            if (!widget.inBounds(mx, my) || !widget.mouseClicked(mx, my, key)) continue;
            return true;
        }
        return false;
    }
}

