/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.ages.api.manual.ConfigHolder;
import com.yanny.ages.api.manual.IManual;
import com.yanny.ages.api.manual.MarginWidget;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;

public class ImageWidget
extends MarginWidget {
    public static final String TYPE = "image";
    protected final ResourceLocation imgRes;
    protected final float scale;
    protected final int tmpWidth;
    protected final int tmpHeight;
    protected final int imgWidth;
    protected final int imgHeight;
    protected final int u;
    protected final int v;

    public ImageWidget(JsonObject object, IManual manual) {
        super(object, manual, ConfigHolder.SCALE, ConfigHolder.WIDTH, ConfigHolder.HEIGHT, ConfigHolder.IMG_WIDTH, ConfigHolder.IMG_HEIGHT, ConfigHolder.IMG_U, ConfigHolder.IMG_V, ConfigHolder.IMAGE);
        this.scale = ((Float)this.configHolder.getValue(ConfigHolder.SCALE)).floatValue();
        this.tmpWidth = (Integer)this.configHolder.getValue(ConfigHolder.WIDTH);
        this.tmpHeight = (Integer)this.configHolder.getValue(ConfigHolder.HEIGHT);
        this.imgWidth = (Integer)this.configHolder.getValue(ConfigHolder.IMG_WIDTH);
        this.imgHeight = (Integer)this.configHolder.getValue(ConfigHolder.IMG_HEIGHT);
        this.u = (Integer)this.configHolder.getValue(ConfigHolder.IMG_U);
        this.v = (Integer)this.configHolder.getValue(ConfigHolder.IMG_V);
        this.imgRes = (ResourceLocation)this.configHolder.getValue(ConfigHolder.IMAGE);
    }

    @Override
    int getRawWidth() {
        return Math.round(this.tmpWidth <= 0 ? (float)this.imgWidth * this.scale : (float)this.tmpWidth * this.scale) + Math.max(this.getRawMarginLeft(), 0) + Math.max(this.getRawMarginRight(), 0);
    }

    @Override
    public int getMinWidth(int height) {
        return this.getRawWidth();
    }

    @Override
    public int getMinHeight(int width) {
        return Math.round(this.tmpHeight <= 0 ? (float)this.imgHeight * this.scale : (float)this.tmpHeight * this.scale) + this.getMarginTop() + this.getMarginBottom();
    }

    @Override
    public void drawBackgroundLayer(Screen screen, int mx, int my) {
        this.mc.func_110434_K().func_110577_a(this.imgRes);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.getX() + this.getMarginLeft()), (float)(this.getY() + this.getMarginTop()), (float)0.0f);
        GlStateManager.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AbstractGui.blit((int)0, (int)0, (int)0, (float)this.u, (float)this.v, (int)this.tmpWidth, (int)this.tmpHeight, (int)this.imgWidth, (int)this.imgHeight);
        GlStateManager.popMatrix();
    }
}

