/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.ages.api.manual.ConfigHolder;
import com.yanny.ages.api.manual.IManual;
import com.yanny.ages.api.manual.MarginWidget;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.config.GuiUtils;

public class ItemWidget
extends MarginWidget {
    public static final String TYPE = "item";
    private static final int ITEM_WIDTH = 16;
    protected final float scale;
    protected final List<String> text;
    protected final ItemStack item;

    public ItemWidget(JsonObject object, IManual manual) {
        super(object, manual, ConfigHolder.SCALE, ConfigHolder.ITEM);
        this.scale = ((Float)this.configHolder.getValue(ConfigHolder.SCALE)).floatValue();
        this.item = (ItemStack)this.configHolder.getValue(ConfigHolder.ITEM);
        this.text = Lists.newArrayList();
        List list = this.item.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        for (ITextComponent itextcomponent : list) {
            this.text.add(itextcomponent.func_150254_d());
        }
    }

    @Override
    int getRawWidth() {
        return Math.round(16.0f * this.scale) + Math.max(this.getRawMarginLeft(), 0) + Math.max(this.getRawMarginRight(), 0);
    }

    @Override
    public int getMinWidth(int height) {
        return this.getRawWidth();
    }

    @Override
    public int getMinHeight(int width) {
        return Math.round(16.0f * this.scale) + this.getMarginTop() + this.getMarginBottom();
    }

    @Override
    public void drawBackgroundLayer(Screen screen, int mx, int my) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.getX() + this.getMarginLeft()), (float)(this.getY() + this.getMarginTop()), (float)0.0f);
        GlStateManager.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        this.mc.func_175599_af().func_180450_b(this.item, 0, 0);
        this.mc.func_175599_af().func_175030_a(this.mc.field_71466_p, this.item, 0, 0);
        RenderHelper.func_74519_b();
        GlStateManager.popMatrix();
    }

    @Override
    public void render(Screen screen, int mx, int my) {
        if (this.inBounds(mx, my)) {
            GuiUtils.drawHoveringText(this.text, (int)mx, (int)my, (int)screen.width, (int)screen.height, (int)-1, (FontRenderer)this.mc.field_71466_p);
        }
    }
}

