/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.ages.api.manual.Align;
import com.yanny.ages.api.manual.ConfigHolder;
import com.yanny.ages.api.manual.ConfigurableWidget;
import com.yanny.ages.api.manual.CustomFontRenderer;
import com.yanny.ages.api.manual.IManual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;

public class ListWidget
extends ConfigurableWidget {
    public static final String TYPE = "list";
    protected final CustomFontRenderer customFontRenderer;
    protected final List<CustomFontRenderer.Link> links = new ArrayList<CustomFontRenderer.Link>();
    protected final int color = (Integer)this.configHolder.getValue(ConfigHolder.COLOR);
    protected final float scale = ((Float)this.configHolder.getValue(ConfigHolder.SCALE)).floatValue();
    protected final int tmpWidth = (Integer)this.configHolder.getValue(ConfigHolder.WIDTH);
    protected final int tmpHeight = (Integer)this.configHolder.getValue(ConfigHolder.HEIGHT);
    protected final int margin_top = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_TOP);
    protected final int margin_left = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_LEFT);
    protected final int margin_bottom = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_BOTTOM);
    protected final int margin_right = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_RIGHT);
    protected final int bulletWidth;
    protected final String bullet;
    protected final String[] list = (String[])this.configHolder.getValue(ConfigHolder.LIST);
    protected final int[] heights;

    public ListWidget(JsonObject object, IManual manual) {
        super(object, manual, ConfigHolder.COLOR, ConfigHolder.SCALE, ConfigHolder.WIDTH, ConfigHolder.HEIGHT, ConfigHolder.MARGIN_TOP, ConfigHolder.MARGIN_LEFT, ConfigHolder.MARGIN_BOTTOM, ConfigHolder.MARGIN_RIGHT, ConfigHolder.LIST, ConfigHolder.BULLET);
        this.bullet = (String)this.configHolder.getValue(ConfigHolder.BULLET);
        this.bulletWidth = this.getBulletWidth(this.bullet + " ");
        this.heights = new int[this.list.length];
        this.customFontRenderer = new CustomFontRenderer(this.mc.field_71466_p);
    }

    @Override
    public int getMinWidth(int height) {
        return Math.max(this.tmpWidth, -1);
    }

    @Override
    public int getMinHeight(int width) {
        return Math.max(this.tmpHeight, Math.round((float)this.getTextHeight(Math.round(width - this.bulletWidth - this.margin_left - this.margin_right)) * this.scale) + this.margin_top + this.margin_bottom);
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        for (int i = 0; i < this.list.length; ++i) {
            this.heights[i] = this.customFontRenderer.getWordWrappedHeight(this.list[i], Math.round((float)(width - this.bulletWidth - this.margin_left - this.margin_right) / this.scale));
        }
    }

    @Override
    public void drawBackgroundLayer(Screen screen, int mx, int my) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.getX() + this.margin_left), (float)(this.getY() + this.margin_top), (float)0.0f);
        GlStateManager.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        GlStateManager.enableBlend();
        RenderHelper.func_74520_c();
        int height = 0;
        for (int i = 0; i < this.list.length; ++i) {
            this.mc.field_71466_p.func_211126_b(this.bullet, 0.0f, (float)height, this.color);
            this.customFontRenderer.drawSplitString(this.list[i], this.bulletWidth, height, Math.round((float)(this.getWidth() - this.bulletWidth - this.margin_left - this.margin_right) / this.scale), this.color, Align.LEFT, false);
            height += this.heights[i];
        }
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.getX() + this.margin_left), (float)(this.getY() + this.margin_top), (float)0.0f);
        GlStateManager.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        this.links.forEach(link -> {
            if (link.inArea(mx - (this.getX() + this.margin_left), my - (this.getY() + this.margin_top), this.scale)) {
                link.rects.forEach(rect -> Screen.fill((int)((int)rect.x1), (int)((int)rect.y1), (int)((int)rect.x2), (int)((int)rect.y2), (int)0x66000000));
            }
        });
        GlStateManager.popMatrix();
    }

    @Override
    public boolean mouseClicked(int mx, int my, int key) {
        for (CustomFontRenderer.Link link : this.links) {
            if (!link.inArea(mx - (this.getX() + this.margin_left), my - (this.getY() + this.margin_top), this.scale)) continue;
            this.manual.changePage(link.key);
            return true;
        }
        return false;
    }

    @Override
    public void setPos(int x, int y) {
        super.setPos(x, y);
        this.links.clear();
        int height = 0;
        for (int i = 0; i < this.list.length; ++i) {
            this.links.addAll(this.customFontRenderer.analyseSplitStringLinks(this.list[i], this.bulletWidth, height, Math.round((float)(this.getWidth() - this.bulletWidth - this.margin_left - this.margin_right) / this.scale), Align.LEFT, false));
            height += this.heights[i];
        }
        this.links.forEach(link -> this.manual.linkExists(link.key));
    }

    private int getTextHeight(int width) {
        int height = 0;
        for (String text : this.list) {
            height += this.customFontRenderer.getWordWrappedHeight(text, Math.round((float)(width - this.bulletWidth - this.margin_left - this.margin_right) / this.scale));
        }
        return height;
    }

    private int getBulletWidth(String bullet) {
        return Math.round(this.mc.field_71466_p.func_78256_a(bullet));
    }
}

