/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yanny.ages.api.manual.ButtonWidget;
import com.yanny.ages.api.manual.IManual;
import com.yanny.ages.api.manual.IRecipeHandler;
import com.yanny.ages.api.manual.PageWidget;
import com.yanny.ages.api.manual.Utils;
import com.yanny.ages.api.manual.Widget;
import com.yanny.ages.api.manual.handlers.BlastingRecipeHandler;
import com.yanny.ages.api.manual.handlers.CampfireRecipeHandler;
import com.yanny.ages.api.manual.handlers.FurnaceRecipeHandler;
import com.yanny.ages.api.manual.handlers.ShapedRecipeHandler;
import com.yanny.ages.api.manual.handlers.ShapelessRecipeHandler;
import com.yanny.ages.api.manual.handlers.SmokingRecipeHandler;
import com.yanny.ages.api.manual.handlers.StonecuttinRecipeHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManualWidget
extends Widget
implements IManual {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private int currentPage = 0;
    private final Screen screen;
    private final Map<Integer, PageWidget> pages = new HashMap<Integer, PageWidget>();
    private final Map<String, Integer> links = new HashMap<String, Integer>();
    private final Set<String> keys = new HashSet<String>();
    private final Map<String, JsonElement> constants = new HashMap<String, JsonElement>();
    private final Map<IRecipeSerializer<?>, IRecipeHandler> recipeHandlerMap = new HashMap();
    private final ButtonWidget prevPage = new ButtonWidget("<", () -> this.setCurrentPage(Math.max(this.currentPage - 1, 0)));
    private final ButtonWidget nextPage = new ButtonWidget(">", () -> this.setCurrentPage(Math.min(this.currentPage + 1, this.pages.size() - 1)));
    private final ButtonWidget menuPage = new ButtonWidget("MENU", () -> this.setCurrentPage(0));

    public ManualWidget(Screen screen, int width, int height) {
        this.recipeHandlerMap.put(IRecipeSerializer.field_222157_a, new ShapedRecipeHandler());
        this.recipeHandlerMap.put(IRecipeSerializer.field_222158_b, new ShapelessRecipeHandler());
        this.recipeHandlerMap.put((IRecipeSerializer<?>)IRecipeSerializer.field_222171_o, new FurnaceRecipeHandler());
        this.recipeHandlerMap.put((IRecipeSerializer<?>)IRecipeSerializer.field_222172_p, new BlastingRecipeHandler());
        this.recipeHandlerMap.put((IRecipeSerializer<?>)IRecipeSerializer.field_222173_q, new SmokingRecipeHandler());
        this.recipeHandlerMap.put((IRecipeSerializer<?>)IRecipeSerializer.field_222174_r, new CampfireRecipeHandler());
        this.recipeHandlerMap.put(IRecipeSerializer.field_222175_s, new StonecuttinRecipeHandler());
        this.setSize(width - 10, height - 10);
        this.prevPage.setSize(20, 20);
        this.nextPage.setSize(20, 20);
        this.menuPage.setSize(60, 20);
        this.screen = screen;
    }

    public void buildFromResources(ResourceLocation resource) {
        JsonObject object;
        IResourceManager manager = this.mc.func_195551_G();
        try (InputStreamReader inputstream = new InputStreamReader(manager.func_199002_a(resource).func_199027_b(), StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inputstream);){
            object = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
        }
        catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
            LOGGER.error("Couldn't parse data file {} - {}", (Object)resource, (Object)jsonparseexception);
            return;
        }
        if (object != null) {
            int page = 0;
            JsonArray array = Utils.getArray(object, "content");
            if (array == null) {
                return;
            }
            this.loadConstants(this.constants, object);
            for (JsonElement element : array) {
                String key;
                if (!element.isJsonObject() || (key = (String)Utils.get(String.class, this, element.getAsJsonObject(), "key", null, false)) == null) continue;
                this.keys.add(key);
            }
            for (JsonElement element : array) {
                if (!element.isJsonObject()) {
                    LOGGER.warn("Element {} is not an object", (Object)element.toString());
                }
                this.pages.put(page, new PageWidget(this, element.getAsJsonObject(), page));
                ++page;
            }
        } else {
            LOGGER.error("Couldn't parse data file {}", (Object)resource);
        }
        this.setCurrentPage(0);
    }

    public void addRecipeHandler(IRecipeSerializer<?> serializer, IRecipeHandler handler) {
        this.recipeHandlerMap.put(serializer, handler);
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
        this.prevPage.setActive(currentPage > 0);
        this.nextPage.setActive(currentPage < this.pages.size() - 1);
    }

    @Override
    public void drawBackgroundLayer(Screen screen, int mx, int my) {
        this.pages.get(this.currentPage).drawBackgroundLayer(screen, mx, my);
        this.prevPage.drawBackgroundLayer(screen, mx, my);
        this.nextPage.drawBackgroundLayer(screen, mx, my);
        this.menuPage.drawBackgroundLayer(screen, mx, my);
    }

    @Override
    public void render(Screen screen, int mx, int my) {
        this.pages.get(this.currentPage).render(screen, mx, my);
        this.prevPage.render(screen, mx, my);
        this.nextPage.render(screen, mx, my);
        this.menuPage.render(screen, mx, my);
    }

    @Override
    public void setPos(int x, int y) {
        super.setPos(x, y);
        this.pages.forEach((index, page) -> page.setPos(x + 5, y + 5));
        this.prevPage.setPos(x, y + this.getHeight() + 10);
        this.nextPage.setPos(x + this.getWidth() + 10 - 20, y + this.getHeight() + 10);
        this.menuPage.setPos(x + this.getWidth() / 2 + 5 - 30, y + this.getHeight() + 10);
    }

    @Override
    public boolean mouseClicked(int mx, int my, int key) {
        return this.pages.get(this.currentPage).mouseClicked(mx, my, key) || this.prevPage.mouseClicked(mx, my, key) || this.nextPage.mouseClicked(mx, my, key) || this.menuPage.mouseClicked(mx, my, key);
    }

    @Override
    public void mouseMoved(int mx, int my) {
        this.pages.get(this.currentPage).mouseMoved(mx, my);
        this.prevPage.mouseMoved(mx, my);
        this.nextPage.mouseMoved(mx, my);
        this.menuPage.mouseMoved(mx, my);
    }

    @Override
    public void addLink(String key, int page) {
        if (key.startsWith("http://") || key.startsWith("https://")) {
            return;
        }
        this.links.put(key, page);
    }

    @Override
    public void changePage(String key) {
        if (key.startsWith("http://") || key.startsWith("https://")) {
            Style style = new Style();
            style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, key));
            this.screen.handleComponentClicked(new StringTextComponent("").func_150255_a(style));
            return;
        }
        Integer page = this.links.get(key);
        if (page == null) {
            LOGGER.warn("Page key '{}' does not exists", (Object)key);
            return;
        }
        this.setCurrentPage(this.links.get(key));
    }

    @Override
    public JsonElement getConstant(String key) {
        return this.constants.get(key);
    }

    @Override
    public void linkExists(String key) {
        if (key.startsWith("http://") || key.startsWith("https://")) {
            return;
        }
        if (!this.keys.contains(key)) {
            LOGGER.warn("Link key '{}' does not exists!", (Object)key);
        }
    }

    @Override
    public IRecipeHandler getRecipeHandler(IRecipe<?> recipe) {
        if (recipe == null) {
            LOGGER.warn("Null recipe");
            return null;
        }
        IRecipeHandler handler = this.recipeHandlerMap.get(recipe.func_199559_b());
        if (handler == null) {
            LOGGER.warn("Recipe handler for serializer '{}' does not exists!", (Object)recipe.func_199559_b().getRegistryName());
        }
        return handler;
    }

    private void loadConstants(Map<String, JsonElement> constants, JsonObject object) {
        JsonObject items = Utils.getObject(object, "constants");
        if (items != null) {
            for (Map.Entry item : items.entrySet()) {
                JsonElement element = (JsonElement)item.getValue();
                if (element.isJsonPrimitive()) {
                    constants.put((String)item.getKey(), element);
                    continue;
                }
                LOGGER.warn("Invalid element type in constants: {}", item.getKey());
            }
        }
    }
}

