/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.yanny.ages.api.manual.Align;
import com.yanny.ages.api.manual.ConfigHolder;
import com.yanny.ages.api.manual.ConfigurableWidget;
import com.yanny.ages.api.manual.IManual;
import org.apache.commons.lang3.ArrayUtils;

public abstract class MarginWidget
extends ConfigurableWidget {
    private final int margin_top;
    private final int margin_bottom;
    private final int tmpMarginLeft;
    private final int tmpMarginRight;
    private final Align align;
    private int margin_left;
    private int margin_right;

    @SafeVarargs
    MarginWidget(JsonObject object, IManual manual, Pair<String, ConfigHolder.Obj<?, ?>> ... types) {
        super(object, manual, (Pair[])ArrayUtils.addAll((Object[])types, (Object[])new Pair[]{ConfigHolder.MARGIN_LEFT_AUTO, ConfigHolder.MARGIN_RIGHT_AUTO, ConfigHolder.MARGIN_TOP, ConfigHolder.MARGIN_BOTTOM, ConfigHolder.ALIGN_CENTER}));
        this.margin_top = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_TOP);
        this.tmpMarginLeft = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_LEFT_AUTO);
        this.margin_bottom = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_BOTTOM);
        this.tmpMarginRight = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_RIGHT_AUTO);
        this.align = (Align)((Object)this.configHolder.getValue(ConfigHolder.ALIGN_CENTER));
    }

    abstract int getRawWidth();

    @Override
    public void setWidth(int width) {
        int minWidth = this.getRawWidth();
        if (minWidth < width) {
            switch (this.align) {
                case CENTER: {
                    if (this.tmpMarginLeft < 0) {
                        if (this.tmpMarginRight < 0) {
                            this.margin_left = this.margin_right = (width - minWidth) / 2;
                            break;
                        }
                        this.margin_left = width - minWidth - this.tmpMarginRight;
                        this.margin_right = this.tmpMarginRight;
                        break;
                    }
                    this.margin_left = this.tmpMarginLeft;
                    this.margin_right = width - minWidth - this.tmpMarginLeft;
                    break;
                }
                case RIGHT: {
                    if (this.tmpMarginLeft < 0) {
                        this.margin_left = width - minWidth;
                        this.margin_right = 0;
                        break;
                    }
                    this.margin_left = this.tmpMarginLeft;
                    this.margin_right = width - minWidth - this.tmpMarginLeft;
                    break;
                }
                case LEFT: {
                    this.margin_left = Math.max(this.tmpMarginLeft, 0);
                    this.margin_right = width - minWidth - this.tmpMarginLeft;
                }
            }
        }
        super.setWidth(width);
    }

    public int getMarginLeft() {
        return this.margin_left;
    }

    public int getRawMarginLeft() {
        return this.tmpMarginLeft;
    }

    public int getMarginTop() {
        return this.margin_top;
    }

    public int getMarginRight() {
        return this.margin_right;
    }

    public int getRawMarginRight() {
        return this.tmpMarginRight;
    }

    public int getMarginBottom() {
        return this.margin_bottom;
    }
}

