/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.ages.api.manual.ConfigHolder;
import com.yanny.ages.api.manual.IManual;
import com.yanny.ages.api.manual.IRecipeHandler;
import com.yanny.ages.api.manual.MarginWidget;
import com.yanny.ages.api.manual.RecipeBackground;
import com.yanny.ages.api.manual.RecipeIngredient;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.config.GuiUtils;

public class RecipeWidget
extends MarginWidget {
    public static final String TYPE = "recipe";
    private static final int ITEM_WIDTH = 16;
    protected final float scale;
    protected final IRecipe<?>[] recipes;
    protected final List<IRecipeHandler> recipeHandlers = new ArrayList<IRecipeHandler>();
    protected final List<RecipeBackground> backgrounds = new ArrayList<RecipeBackground>();
    protected final List<List<RecipeIngredient>> recipeIngredients = new ArrayList<List<RecipeIngredient>>();

    public RecipeWidget(JsonObject object, IManual manual) {
        super(object, manual, ConfigHolder.RECIPE, ConfigHolder.SCALE);
        this.scale = ((Float)this.configHolder.getValue(ConfigHolder.SCALE)).floatValue();
        for (IRecipe<?> recipe : this.recipes = (IRecipe[])this.configHolder.getValue(ConfigHolder.RECIPE)) {
            IRecipeHandler recipeHandler = manual.getRecipeHandler(recipe);
            this.recipeHandlers.add(recipeHandler);
            this.backgrounds.add(recipeHandler.getRecipeBackground());
            this.recipeIngredients.add(recipeHandler.getRecipeIngredients(recipe));
        }
    }

    @Override
    int getRawWidth() {
        return Collections.max(this.backgrounds, Comparator.comparing((Function<RecipeBackground, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getRawWidth$0(com.yanny.ages.api.manual.RecipeBackground ), (Lcom/yanny/ages/api/manual/RecipeBackground;)Ljava/lang/Float;)((RecipeWidget)this))).width + Math.max(this.getRawMarginLeft(), 0) + Math.max(this.getRawMarginRight(), 0);
    }

    @Override
    public int getMinWidth(int height) {
        return this.getRawWidth();
    }

    @Override
    public int getMinHeight(int width) {
        return Collections.max(this.backgrounds, Comparator.comparing((Function<RecipeBackground, Float>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getMinHeight$1(com.yanny.ages.api.manual.RecipeBackground ), (Lcom/yanny/ages/api/manual/RecipeBackground;)Ljava/lang/Float;)((RecipeWidget)this))).height + this.getMarginTop() + this.getMarginBottom();
    }

    @Override
    public void drawBackgroundLayer(Screen screen, int mx, int my) {
        int tmp = (int)(System.currentTimeMillis() / 2000L);
        int recipeIndex = tmp % this.recipeIngredients.size();
        this.mc.func_110434_K().func_110577_a(this.backgrounds.get((int)recipeIndex).image);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.getX() + this.getMarginLeft()), (float)(this.getY() + this.getMarginTop()), (float)0.0f);
        GlStateManager.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AbstractGui.blit((int)0, (int)0, (int)0, (float)this.backgrounds.get((int)recipeIndex).u, (float)this.backgrounds.get((int)recipeIndex).v, (int)this.backgrounds.get((int)recipeIndex).width, (int)this.backgrounds.get((int)recipeIndex).height, (int)this.backgrounds.get((int)recipeIndex).imgW, (int)this.backgrounds.get((int)recipeIndex).imgH);
        GlStateManager.popMatrix();
    }

    @Override
    public void render(Screen screen, int mx, int my) {
        ItemStack[] stacks;
        int tmp = (int)(System.currentTimeMillis() / 2000L);
        int recipeIndex = tmp % this.recipeIngredients.size();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.getX() + this.getMarginLeft()), (float)(this.getY() + this.getMarginTop()), (float)0.0f);
        GlStateManager.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        List<RecipeIngredient> ingredients = this.recipeIngredients.get(recipeIndex);
        for (RecipeIngredient ingredient : ingredients) {
            stacks = ingredient.item.func_193365_a();
            if (stacks.length <= 0) continue;
            this.mc.func_175599_af().func_180450_b(stacks[tmp % stacks.length], ingredient.x, ingredient.y);
            this.mc.func_175599_af().func_175030_a(this.mc.field_71466_p, stacks[tmp % stacks.length], ingredient.x, ingredient.y);
        }
        RenderHelper.func_74519_b();
        GlStateManager.popMatrix();
        this.mc.func_110434_K().func_110577_a(this.backgrounds.get((int)recipeIndex).image);
        if (this.inBounds(mx, my)) {
            for (RecipeIngredient ingredient : ingredients) {
                stacks = ingredient.item.func_193365_a();
                if (stacks.length <= 0 || !((float)(this.getX() + this.getMarginLeft()) + (float)ingredient.x * this.scale < (float)mx) || !((float)mx < (float)(this.getX() + this.getMarginLeft()) + (float)(ingredient.x + 16) * this.scale) || !((float)(this.getY() + this.getMarginTop()) + (float)ingredient.y * this.scale < (float)my) || !((float)my < (float)(this.getY() + this.getMarginTop()) + (float)(ingredient.y + 16) * this.scale)) continue;
                GuiUtils.drawHoveringText(this.getText(stacks[tmp % stacks.length]), (int)mx, (int)my, (int)screen.width, (int)screen.height, (int)-1, (FontRenderer)this.mc.field_71466_p);
            }
        }
    }

    @Nonnull
    private List<String> getText(@Nonnull ItemStack ingredient) {
        List list = ingredient.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        ArrayList<String> text = new ArrayList<String>();
        for (ITextComponent itextcomponent : list) {
            text.add(itextcomponent.func_150254_d());
        }
        return text;
    }

    private /* synthetic */ Float lambda$getMinHeight$1(RecipeBackground b) {
        return Float.valueOf((float)b.height * this.scale);
    }

    private /* synthetic */ Float lambda$getRawWidth$0(RecipeBackground b) {
        return Float.valueOf((float)b.width * this.scale);
    }
}

