/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.ages.api.manual.Align;
import com.yanny.ages.api.manual.ConfigHolder;
import com.yanny.ages.api.manual.ConfigurableWidget;
import com.yanny.ages.api.manual.CustomFontRenderer;
import com.yanny.ages.api.manual.IManual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;

public class TextWidget
extends ConfigurableWidget {
    public static final String TYPE = "text";
    protected final String text;
    protected final List<CustomFontRenderer.Link> links = new ArrayList<CustomFontRenderer.Link>();
    protected final CustomFontRenderer customFontRenderer;
    protected final int color;
    protected final float scale;
    protected final int tmpWidth;
    protected final int tmpHeight;
    protected final int margin_top;
    protected final int margin_left;
    protected final int margin_bottom;
    protected final int margin_right;
    protected final Align align;
    protected final boolean justify;

    public TextWidget(JsonObject object, IManual manual) {
        super(object, manual, ConfigHolder.TEXT, ConfigHolder.SCALE, ConfigHolder.COLOR, ConfigHolder.WIDTH, ConfigHolder.HEIGHT, ConfigHolder.MARGIN_TOP, ConfigHolder.MARGIN_LEFT, ConfigHolder.MARGIN_BOTTOM, ConfigHolder.MARGIN_RIGHT, ConfigHolder.ALIGN_LEFT, ConfigHolder.JUSTIFY);
        this.text = (String)this.configHolder.getValue(ConfigHolder.TEXT);
        this.color = (Integer)this.configHolder.getValue(ConfigHolder.COLOR);
        this.scale = ((Float)this.configHolder.getValue(ConfigHolder.SCALE)).floatValue();
        this.tmpWidth = (Integer)this.configHolder.getValue(ConfigHolder.WIDTH);
        this.tmpHeight = (Integer)this.configHolder.getValue(ConfigHolder.HEIGHT);
        this.margin_top = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_TOP);
        this.margin_left = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_LEFT);
        this.margin_bottom = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_BOTTOM);
        this.margin_right = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_RIGHT);
        this.align = (Align)((Object)this.configHolder.getValue(ConfigHolder.ALIGN_LEFT));
        this.justify = (Boolean)this.configHolder.getValue(ConfigHolder.JUSTIFY);
        this.customFontRenderer = new CustomFontRenderer(this.mc.field_71466_p);
    }

    @Override
    public int getMinWidth(int height) {
        return Math.max(this.tmpWidth, -1);
    }

    @Override
    public int getMinHeight(int width) {
        return Math.max(this.tmpHeight, Math.round((float)this.getTextHeight(Math.round((float)(width - this.margin_left - this.margin_right) / this.scale)) * this.scale) + this.margin_top + this.margin_bottom);
    }

    @Override
    public void setPos(int x, int y) {
        super.setPos(x, y);
        this.links.clear();
        this.links.addAll(this.customFontRenderer.analyseSplitStringLinks(this.text, 0, 0, Math.round((float)(this.getWidth() - this.margin_left - this.margin_right) / this.scale), this.align, this.justify));
        this.links.forEach(link -> this.manual.linkExists(link.key));
    }

    @Override
    public void drawBackgroundLayer(Screen screen, int mx, int my) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.getX() + this.margin_left), (float)(this.getY() + this.margin_top), (float)0.0f);
        GlStateManager.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        GlStateManager.enableBlend();
        RenderHelper.func_74520_c();
        this.customFontRenderer.drawSplitString(this.text, 0, 0, Math.round((float)(this.getWidth() - this.margin_left - this.margin_right) / this.scale), this.color, this.align, this.justify);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(this.getX() + this.margin_left), (float)(this.getY() + this.margin_top), (float)0.0f);
        GlStateManager.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        this.links.forEach(link -> {
            if (link.inArea(mx - (this.getX() + this.margin_left), my - (this.getY() + this.margin_top), this.scale)) {
                link.rects.forEach(rect -> Screen.fill((int)((int)rect.x1), (int)((int)rect.y1), (int)((int)rect.x2), (int)((int)rect.y2), (int)0x66000000));
            }
        });
        GlStateManager.popMatrix();
    }

    @Override
    public boolean mouseClicked(int mx, int my, int key) {
        for (CustomFontRenderer.Link link : this.links) {
            if (!link.inArea(mx - (this.getX() + this.margin_left), my - (this.getY() + this.margin_top), this.scale)) continue;
            this.manual.changePage(link.key);
            return true;
        }
        return false;
    }

    private int getTextHeight(int width) {
        return this.customFontRenderer.getWordWrappedHeight(this.text, width);
    }
}

