/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.ages.api.manual.Align;
import com.yanny.ages.api.manual.ConfigHolder;
import com.yanny.ages.api.manual.ConfigurableWidget;
import com.yanny.ages.api.manual.IManual;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;

public class TitleWidget
extends ConfigurableWidget {
    public static final String TYPE = "title";
    protected final String text;
    protected final int color;
    protected final float scale;
    protected final int tmpWidth;
    protected final int tmpHeight;
    protected final int margin_top;
    protected final int margin_left;
    protected final int margin_bottom;
    protected final int margin_right;
    protected final Align align;

    public TitleWidget(JsonObject object, IManual manual) {
        super(object, manual, ConfigHolder.TEXT, ConfigHolder.SCALE, ConfigHolder.COLOR, ConfigHolder.WIDTH, ConfigHolder.HEIGHT, ConfigHolder.MARGIN_TOP, ConfigHolder.MARGIN_LEFT, ConfigHolder.MARGIN_BOTTOM, ConfigHolder.MARGIN_RIGHT, ConfigHolder.ALIGN_CENTER);
        this.text = (String)this.configHolder.getValue(ConfigHolder.TEXT);
        this.color = (Integer)this.configHolder.getValue(ConfigHolder.COLOR);
        this.scale = ((Float)this.configHolder.getValue(ConfigHolder.SCALE)).floatValue();
        this.tmpWidth = (Integer)this.configHolder.getValue(ConfigHolder.WIDTH);
        this.tmpHeight = (Integer)this.configHolder.getValue(ConfigHolder.HEIGHT);
        this.margin_top = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_TOP);
        this.margin_left = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_LEFT);
        this.margin_bottom = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_BOTTOM);
        this.margin_right = (Integer)this.configHolder.getValue(ConfigHolder.MARGIN_RIGHT);
        this.align = (Align)((Object)this.configHolder.getValue(ConfigHolder.ALIGN_CENTER));
    }

    @Override
    public int getMinWidth(int height) {
        return Math.max(this.tmpWidth, -1);
    }

    @Override
    public int getMinHeight(int width) {
        this.mc.field_71466_p.getClass();
        return Math.max(this.tmpHeight, Math.round(9.0f * this.scale) + this.margin_top + this.margin_bottom);
    }

    @Override
    public void drawBackgroundLayer(Screen screen, int mx, int my) {
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translatef((float)(this.getX() + this.margin_left), (float)(this.getY() + this.margin_top), (float)0.0f);
        GlStateManager.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        RenderHelper.func_74520_c();
        switch (this.align) {
            case LEFT: {
                screen.drawString(this.mc.field_71466_p, this.text, 0, 0, this.color);
                break;
            }
            case RIGHT: {
                screen.drawRightAlignedString(this.mc.field_71466_p, this.text, Math.round((float)(this.getWidth() - this.margin_left - this.margin_right) / this.scale), 0, this.color);
                break;
            }
            case CENTER: {
                screen.drawCenteredString(this.mc.field_71466_p, this.text, Math.round((float)(this.getWidth() - this.margin_left - this.margin_right) / this.scale / 2.0f), 0, this.color);
            }
        }
        GlStateManager.popMatrix();
    }
}

