/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.manual;

import com.google.gson.JsonObject;
import com.yanny.ages.api.manual.HorizontalLayoutWidget;
import com.yanny.ages.api.manual.IManual;
import com.yanny.ages.api.manual.ImageWidget;
import com.yanny.ages.api.manual.ItemWidget;
import com.yanny.ages.api.manual.ListWidget;
import com.yanny.ages.api.manual.RecipeWidget;
import com.yanny.ages.api.manual.TextWidget;
import com.yanny.ages.api.manual.TitleWidget;
import com.yanny.ages.api.manual.VerticalLayoutWidget;
import com.yanny.ages.api.manual.Widget;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class WidgetFactory {
    private static final Map<String, FactoryFunction<JsonObject, IManual, Widget>> FACTORY = new HashMap<String, FactoryFunction<JsonObject, IManual, Widget>>();
    private static final Logger LOGGER = LogManager.getLogger();

    WidgetFactory() {
    }

    static Widget getWidget(String name, JsonObject object, IManual manual) {
        FactoryFunction<JsonObject, IManual, Widget> w = FACTORY.get(name);
        if (w != null) {
            return FACTORY.get(name).apply(object, manual);
        }
        LOGGER.warn("Widget '{}' does not exists!", (Object)name);
        return new EmptyWidget();
    }

    static {
        FACTORY.put("text", TextWidget::new);
        FACTORY.put("title", TitleWidget::new);
        FACTORY.put("item", ItemWidget::new);
        FACTORY.put("hlayout", HorizontalLayoutWidget::new);
        FACTORY.put("vlayout", VerticalLayoutWidget::new);
        FACTORY.put("image", ImageWidget::new);
        FACTORY.put("recipe", RecipeWidget::new);
        FACTORY.put("list", ListWidget::new);
    }

    private static class EmptyWidget
    extends Widget {
        private EmptyWidget() {
        }
    }

    static interface FactoryFunction<A, B, R> {
        public R apply(A var1, B var2);
    }
}

