/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ages.api.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.ForgeConfig;

public class ItemStackUtils {
    public static CompoundNBT serializeStacks(@Nonnull NonNullList<ItemStack> stacks) {
        ListNBT listNBT = new ListNBT();
        CompoundNBT compoundNBT = new CompoundNBT();
        stacks.forEach(itemStack -> {
            CompoundNBT nbt = new CompoundNBT();
            itemStack.func_77955_b(nbt);
            listNBT.add((Object)nbt);
        });
        compoundNBT.func_218657_a("Items", (INBT)listNBT);
        return compoundNBT;
    }

    public static CompoundNBT serializeIngredients(@Nonnull List<Ingredient> ingredients) {
        ListNBT listNBT = new ListNBT();
        CompoundNBT compoundNBT = new CompoundNBT();
        ingredients.forEach(ingredient -> {
            ListNBT itemsNBT = new ListNBT();
            CompoundNBT itemsCompound = new CompoundNBT();
            for (ItemStack itemStack : ingredient.func_193365_a()) {
                CompoundNBT nbt = new CompoundNBT();
                itemStack.func_77955_b(nbt);
                itemsNBT.add((Object)nbt);
            }
            itemsCompound.func_218657_a("Items", (INBT)itemsNBT);
            listNBT.add((Object)itemsCompound);
        });
        compoundNBT.func_218657_a("Items", (INBT)listNBT);
        return compoundNBT;
    }

    public static void deserializeStacks(@Nonnull CompoundNBT compoundNBT, @Nonnull NonNullList<ItemStack> stacks) {
        assert (compoundNBT.func_150297_b("Items", 9));
        ListNBT listNBT = compoundNBT.func_150295_c("Items", 10);
        assert (listNBT.size() == stacks.size());
        AtomicInteger cnt = new AtomicInteger(0);
        listNBT.forEach(nbt -> {
            ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)nbt));
            stacks.set(cnt.getAndIncrement(), (Object)itemStack);
        });
    }

    public static void deserializeIngredients(@Nonnull CompoundNBT compoundNBT, @Nonnull List<Ingredient> ingredients) {
        assert (compoundNBT.func_150297_b("Items", 9));
        ListNBT listNBT = compoundNBT.func_150295_c("Items", 10);
        ingredients.clear();
        listNBT.forEach(nbt -> {
            assert (((CompoundNBT)nbt).func_150297_b("Items", 9));
            ListNBT itemsNBT = ((CompoundNBT)nbt).func_150295_c("Items", 10);
            ArrayList itemStacks = new ArrayList();
            itemsNBT.forEach(itemNbt -> {
                ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)itemNbt));
                itemStacks.add(itemStack);
            });
            ingredients.add(Ingredient.func_193369_a((ItemStack[])itemStacks.toArray(new ItemStack[0])));
        });
    }

    public static void insertItems(@Nonnull List<ItemStack> input, List<ItemStack> output, int startIndex, int endIndex) {
        assert (output.size() > startIndex && output.size() >= endIndex && startIndex < endIndex);
        for (ItemStack itemStack : input) {
            if (itemStack.func_190926_b()) {
                return;
            }
            int index = ItemStackUtils.getFirstFreeOrValid(itemStack, output, startIndex, endIndex);
            if (index < 0) {
                return;
            }
            int items = itemStack.func_190916_E();
            if (!output.get(index).func_190926_b()) {
                while (items > 0) {
                    ItemStack item = output.get(index);
                    int amount = item.func_77976_d() - item.func_190916_E();
                    if (amount < items) {
                        item.func_190917_f(amount);
                        items -= amount;
                        index = ItemStackUtils.getFirstFreeOrValid(itemStack, output, index, endIndex);
                        continue;
                    }
                    item.func_190917_f(items);
                    items = 0;
                }
                continue;
            }
            output.set(index, itemStack.func_77946_l());
        }
    }

    public static void renderItem(ItemStack stack, float alpha, ItemCameraTransforms.TransformType cameraTransformType) {
        if (!stack.func_190926_b()) {
            IBakedModel ibakedmodel = ItemStackUtils.getModelWithOverrides(stack);
            ItemStackUtils.renderItemModel(stack, ibakedmodel, cameraTransformType, alpha);
        }
    }

    public static IBakedModel getModelWithOverrides(ItemStack stack) {
        return ItemStackUtils.getItemModelWithOverrides(stack, null, null);
    }

    public static IBakedModel getItemModelWithOverrides(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entitylivingbaseIn) {
        IBakedModel ibakedmodel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        Item item = stack.func_77973_b();
        return !item.func_185040_i() ? ibakedmodel : ItemStackUtils.getModelWithOverrides(ibakedmodel, stack, worldIn, entitylivingbaseIn);
    }

    public static void renderItem(ItemStack stack, IBakedModel model, float alpha) {
        if (!stack.func_190926_b()) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            if (model.func_188618_c()) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GlStateManager.enableRescaleNormal();
                stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
            } else {
                ItemStackUtils.renderModel(model, stack, alpha);
                if (stack.func_77962_s()) {
                    ItemStackUtils.renderEffect(Minecraft.func_71410_x().field_71446_o, () -> ItemStackUtils.renderModel(model), 8);
                }
            }
            GlStateManager.popMatrix();
        }
    }

    public static void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color) {
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)color);
        }
    }

    public static void renderEffect(TextureManager textureManagerIn, Runnable renderModelFunction, int scale) {
        GlStateManager.depthMask((boolean)false);
        GlStateManager.depthFunc((int)514);
        GlStateManager.disableLighting();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        textureManagerIn.func_110577_a(ItemRenderer.field_110798_h);
        GlStateManager.matrixMode((int)5890);
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        float f = (float)(Util.func_211177_b() % 3000L) / 3000.0f / (float)scale;
        GlStateManager.translatef((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderModelFunction.run();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        float f1 = (float)(Util.func_211177_b() % 4873L) / 4873.0f / (float)scale;
        GlStateManager.translatef((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        renderModelFunction.run();
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.enableLighting();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        textureManagerIn.func_110577_a(AtlasTexture.field_110575_b);
    }

    protected static void renderItemModel(ItemStack stack, IBakedModel bakedmodel, ItemCameraTransforms.TransformType transform, float alpha) {
        if (!stack.func_190926_b()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            Minecraft.func_71410_x().func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174936_b(false, false);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            GlStateManager.enableRescaleNormal();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.pushMatrix();
            bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)transform, (boolean)false);
            ItemStackUtils.renderItem(stack, bakedmodel, alpha);
            GlStateManager.cullFace((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            GlStateManager.popMatrix();
            GlStateManager.disableRescaleNormal();
            GlStateManager.disableBlend();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            Minecraft.func_71410_x().func_110434_K().func_110581_b(AtlasTexture.field_110575_b).func_174935_a();
        }
    }

    private static IBakedModel getModelWithOverrides(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
        IBakedModel ibakedmodel = model.func_188617_f().func_209581_a(model, stack, worldIn, entityIn);
        return ibakedmodel == null ? Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174951_a() : ibakedmodel;
    }

    private static void renderModel(IBakedModel model, ItemStack stack, float alpha) {
        ItemStackUtils.renderModel(model, 0xFFFFFF | Math.round(alpha * 255.0f) << 24, stack);
    }

    private static void renderModel(IBakedModel model) {
        ItemStackUtils.renderModel(model, -8372020, ItemStack.field_190927_a);
    }

    private static void renderModel(IBakedModel model, int color, ItemStack stack) {
        if (((Boolean)ForgeConfig.CLIENT.allowEmissiveItems.get()).booleanValue()) {
            ForgeHooksClient.renderLitItem((ItemRenderer)Minecraft.func_71410_x().func_175599_af(), (IBakedModel)model, (int)color, (ItemStack)stack);
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ItemStackUtils.renderQuads(bufferbuilder, model.func_200117_a(null, direction, random), color);
        }
        random.setSeed(42L);
        ItemStackUtils.renderQuads(bufferbuilder, model.func_200117_a(null, null, random), color);
        tessellator.func_78381_a();
    }

    private static int getFirstFreeOrValid(ItemStack item, List<ItemStack> output, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack itemStack = output.get(i);
            if (!(itemStack.func_77969_a(item) ? itemStack.func_190916_E() < itemStack.func_77976_d() : itemStack.func_190926_b())) continue;
            return i;
        }
        return -1;
    }
}

