/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.yanny.age.stone.blocks.IInventoryInterface;
import com.yanny.age.stone.blocks.MillstoneContainer;
import com.yanny.age.stone.recipes.MillstoneRecipe;
import com.yanny.age.stone.subscribers.TileEntitySubscriber;
import com.yanny.ages.api.utils.ItemStackUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class MillstoneTileEntity
extends TileEntity
implements IInventoryInterface,
ITickableTileEntity,
INamedContainerProvider {
    static final int ITEMS = 2;
    private static final double PI2 = Math.PI * 2;
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private final IItemHandlerModifiable nonSidedItemHandler = this.createNonSidedInventoryHandler(this.stacks);
    private final LazyOptional<IItemHandlerModifiable> sidedInventoryHandler = LazyOptional.of(() -> this.createSidedInventoryHandler(this.stacks));
    private final LazyOptional<IItemHandlerModifiable> nonSidedInventoryHandler = LazyOptional.of(() -> this.nonSidedItemHandler);
    private final RecipeWrapper inventoryWrapper = new RecipeWrapper(this.nonSidedItemHandler);
    private final IItemHandlerModifiable tmpItemHandler = new ItemStackHandler(1);
    private final RecipeWrapper tmpItemHandlerWrapper = new RecipeWrapper(this.tmpItemHandler);
    private final IIntArray data = this.getData();
    private float rotation = 0.0f;
    private boolean active = false;
    private int activateTicks = 0;
    private int ticks = 0;
    private ItemStack result = ItemStack.field_190927_a;

    public MillstoneTileEntity() {
        super(TileEntitySubscriber.millstone);
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        if (this.active) {
            if (this.field_145850_b.field_73012_v.nextInt(5) == 0) {
                double d0 = (double)((float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
                double d1 = (double)((float)this.field_174879_c.func_177956_o() + 0.4375f) + 0.025;
                double d2 = (double)((float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197614_g, d0, d1, d2, 0.0, (double)this.field_145850_b.field_73012_v.nextFloat(), 0.0);
            }
            this.rotation = (float)((double)this.rotation + 0.07853981633974483);
            this.rotation = (float)((double)this.rotation % (Math.PI * 2));
            ++this.ticks;
            if (this.ticks % 20 == 0) {
                this.active = false;
                if (!this.field_145850_b.field_72995_K && this.ticks == this.activateTicks) {
                    if (((ItemStack)this.stacks.get(1)).func_190926_b()) {
                        this.stacks.set(1, (Object)this.result);
                    } else {
                        ((ItemStack)this.stacks.get(1)).func_190917_f(this.result.func_190916_E());
                    }
                    this.ticks = 0;
                    this.result = ItemStack.field_190927_a;
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
                }
            }
        }
    }

    @Nullable
    public Container createMenu(int id, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity entity) {
        assert (this.field_145850_b != null);
        return new MillstoneContainer(id, this.field_174879_c, this.field_145850_b, inventory, entity, this.data);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        assert (this.func_200662_C().getRegistryName() != null);
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.inventoryWrapper;
    }

    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        ItemStackUtils.deserializeStacks((CompoundNBT)invTag, this.stacks);
        this.active = tag.func_74767_n("active");
        this.rotation = tag.func_74760_g("rotation");
        this.ticks = tag.func_74762_e("ticks");
        this.result = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("result"));
        this.activateTicks = tag.func_74762_e("activateTicks");
        super.func_145839_a(tag);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)ItemStackUtils.serializeStacks(this.stacks));
        tag.func_74757_a("active", this.active);
        tag.func_74776_a("rotation", this.rotation);
        tag.func_74768_a("ticks", this.ticks);
        CompoundNBT resTag = new CompoundNBT();
        this.result.func_77955_b(resTag);
        tag.func_218657_a("result", (INBT)resTag);
        tag.func_74768_a("activateTicks", this.activateTicks);
        return super.func_189515_b(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), this.func_200662_C().hashCode(), this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null) {
                return this.sidedInventoryHandler.cast();
            }
            return this.nonSidedInventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        this.sidedInventoryHandler.invalidate();
        this.nonSidedInventoryHandler.invalidate();
        super.func_145843_s();
    }

    ItemStack getResult() {
        return this.result;
    }

    int getPerc() {
        return Math.round((float)this.ticks / (float)this.activateTicks * 100.0f);
    }

    boolean isItemValid(ItemStack itemStack) {
        return this.getRecipe(itemStack).isPresent();
    }

    private IItemHandlerModifiable createNonSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (MillstoneTileEntity.this.isItemValid(stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            protected void onContentsChanged(int slot) {
                assert (MillstoneTileEntity.this.field_145850_b != null);
                MillstoneTileEntity.this.func_70296_d();
                MillstoneTileEntity.this.field_145850_b.func_184138_a(MillstoneTileEntity.this.func_174877_v(), MillstoneTileEntity.this.func_195044_w(), MillstoneTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    private IItemHandlerModifiable createSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 1) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot == 0 && MillstoneTileEntity.this.isItemValid(stack)) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            protected void onContentsChanged(int slot) {
                assert (MillstoneTileEntity.this.field_145850_b != null);
                MillstoneTileEntity.this.func_70296_d();
                MillstoneTileEntity.this.field_145850_b.func_184138_a(MillstoneTileEntity.this.func_174877_v(), MillstoneTileEntity.this.func_195044_w(), MillstoneTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    public float rotateAngle() {
        return this.rotation;
    }

    void onActivated() {
        assert (this.field_145850_b != null);
        if (!this.active) {
            if (this.result.func_190926_b() && !((ItemStack)this.stacks.get(0)).func_190926_b()) {
                this.getRecipe((ItemStack)this.stacks.get(0)).ifPresent(millstoneRecipe -> {
                    ItemStack recipeResult = millstoneRecipe.func_77571_b().func_77946_l();
                    if (((ItemStack)this.stacks.get(1)).func_190926_b() || ((ItemStack)this.stacks.get(1)).func_77973_b().equals(recipeResult.func_77973_b()) && ((ItemStack)this.stacks.get(1)).func_190916_E() < ((ItemStack)this.stacks.get(1)).func_77976_d() - recipeResult.func_190916_E()) {
                        ((ItemStack)this.stacks.get(0)).func_190918_g(1);
                        this.result = recipeResult;
                        this.active = true;
                        this.activateTicks = millstoneRecipe.getActivateCount() * 20;
                        this.ticks = 0;
                        this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 0.5f, 1.0f);
                        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
                    }
                });
            } else if (!this.result.func_190926_b()) {
                this.active = true;
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 0.5f, 1.0f);
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    @Nonnull
    private Optional<MillstoneRecipe> getRecipe(@Nonnull ItemStack item) {
        assert (this.field_145850_b != null);
        this.tmpItemHandler.setStackInSlot(0, item);
        return this.field_145850_b.func_199532_z().func_215371_a(MillstoneRecipe.millstone, (IInventory)this.tmpItemHandlerWrapper, this.field_145850_b);
    }

    @Nonnull
    private IIntArray getData() {
        return new IIntArray(){

            public int func_221476_a(int index) {
                return Math.round((float)MillstoneTileEntity.this.ticks / (float)MillstoneTileEntity.this.activateTicks * 100.0f);
            }

            public void func_221477_a(int index, int value) {
            }

            public int func_221478_a() {
                return 1;
            }
        };
    }
}

