/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.yanny.age.stone.blocks.IInventoryInterface;
import com.yanny.age.stone.blocks.StoneChestBlock;
import com.yanny.age.stone.blocks.StoneChestContainer;
import com.yanny.age.stone.subscribers.TileEntitySubscriber;
import com.yanny.ages.api.utils.ItemStackUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class StoneChestTileEntity
extends LockableLootTileEntity
implements IInventoryInterface,
INamedContainerProvider,
IChestLid,
ITickableTileEntity {
    static final int INVENTORY_WIDTH = 5;
    static final int INVENTORY_HEIGHT = 3;
    private NonNullList<ItemStack> stacks = NonNullList.func_191196_a();
    private final IItemHandlerModifiable nonSidedItemHandler = this.createNonSidedInventoryHandler(this.stacks);
    private final LazyOptional<IItemHandlerModifiable> nonSidedInventoryHandler = LazyOptional.of(() -> this.nonSidedItemHandler);
    private final RecipeWrapper inventoryWrapper = new RecipeWrapper(this.nonSidedItemHandler);
    private float lidAngle;
    private float prevLidAngle;
    private int numPlayersUsing;
    private int ticksSinceSync;

    public StoneChestTileEntity() {
        super(TileEntitySubscriber.stone_chest);
        for (int i = 0; i < 15; ++i) {
            this.stacks.add((Object)ItemStack.field_190927_a);
        }
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        this.numPlayersUsing = StoneChestTileEntity.calculatePlayersUsingSync(this.field_145850_b, this, this.ticksSinceSync, i, j, k, this.numPlayersUsing);
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.playSound();
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f1 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.05f) : (this.lidAngle -= 0.05f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && f1 >= 0.5f) {
                this.playSound();
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.inventoryWrapper;
    }

    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        if (!this.func_184283_b(tag)) {
            ItemStackUtils.deserializeStacks((CompoundNBT)invTag, this.stacks);
        }
        super.func_145839_a(tag);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        if (!this.func_184282_c(tag)) {
            tag.func_218657_a("inv", (INBT)ItemStackUtils.serializeStacks(this.stacks));
        }
        return super.func_189515_b(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), this.func_200662_C().hashCode(), this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.nonSidedInventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        this.nonSidedInventoryHandler.invalidate();
        super.func_145843_s();
    }

    @Nonnull
    protected NonNullList<ItemStack> func_190576_q() {
        return this.stacks;
    }

    protected void func_199721_a(@Nonnull NonNullList<ItemStack> itemsIn) {
        this.stacks = itemsIn;
    }

    @Nonnull
    protected Container func_213906_a(int id, @Nonnull PlayerInventory player) {
        assert (this.field_145850_b != null);
        return new StoneChestContainer(id, this.field_174879_c, this.field_145850_b, player, player.field_70458_d);
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        assert (this.func_200662_C().getRegistryName() != null);
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        return new StringTextComponent("StoneChest");
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public boolean func_191420_l() {
        return false;
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            assert (this.field_145850_b != null);
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    private void onOpenOrClose() {
        assert (this.field_145850_b != null);
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof StoneChestBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    private void playSound() {
        assert (this.field_145850_b != null);
        double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
        double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
        double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
        this.field_145850_b.func_184148_a(null, d0, d1, d2, SoundEvents.field_219642_eu, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    private IItemHandlerModifiable createNonSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                assert (StoneChestTileEntity.this.field_145850_b != null);
                StoneChestTileEntity.this.func_70296_d();
                StoneChestTileEntity.this.field_145850_b.func_184138_a(StoneChestTileEntity.this.func_174877_v(), StoneChestTileEntity.this.func_195044_w(), StoneChestTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    private static int calculatePlayersUsingSync(World world, StoneChestTileEntity tileEntity, int tickSinceSync, int x, int y, int z, int numUsing) {
        if (!world.field_72995_K && numUsing != 0 && (tickSinceSync + x + y + z) % 200 == 0) {
            numUsing = StoneChestTileEntity.calculatePlayersUsing(world, tileEntity, x, y, z);
        }
        return numUsing;
    }

    private static int calculatePlayersUsing(World world, StoneChestTileEntity tileEntity, int x, int y, int z) {
        int i = 0;
        float f = 5.0f;
        for (PlayerEntity playerentity : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)x - f), (double)((float)y - f), (double)((float)z - f), (double)((float)(x + 1) + f), (double)((float)(y + 1) + f), (double)((float)(z + 1) + f)))) {
            IInventory iinventory;
            if (!(playerentity.field_71070_bA instanceof StoneChestContainer) || (iinventory = ((StoneChestContainer)playerentity.field_71070_bA).getIInventory()) != tileEntity.inventoryWrapper) continue;
            ++i;
        }
        return i;
    }
}

