/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.yanny.age.stone.blocks.IInventoryInterface;
import com.yanny.age.stone.config.Config;
import com.yanny.age.stone.recipes.TanningRackRecipe;
import com.yanny.age.stone.subscribers.TileEntitySubscriber;
import com.yanny.ages.api.utils.ItemStackUtils;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TanningRackTileEntity
extends TileEntity
implements IInventoryInterface {
    public static final int ITEMS = 1;
    private static final Random random = new Random(System.currentTimeMillis());
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private final IItemHandlerModifiable nonSidedItemHandler = this.createNonSidedInventoryHandler(this.stacks);
    private final LazyOptional<IItemHandlerModifiable> sidedInventoryHandler = LazyOptional.of(() -> this.createSidedInventoryHandler(this.stacks));
    private final LazyOptional<IItemHandlerModifiable> nonSidedInventoryHandler = LazyOptional.of(() -> this.nonSidedItemHandler);
    private final RecipeWrapper inventoryWrapper = new RecipeWrapper(this.nonSidedItemHandler);
    private final IItemHandlerModifiable tmpItemHandler = new ItemStackHandler(1);
    private final RecipeWrapper tmpItemHandlerWrapper = new RecipeWrapper(this.tmpItemHandler);

    public TanningRackTileEntity() {
        super(TileEntitySubscriber.tanning_rack);
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.inventoryWrapper;
    }

    @Nonnull
    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        ItemStackUtils.deserializeStacks((CompoundNBT)invTag, this.stacks);
        super.func_145839_a(tag);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)ItemStackUtils.serializeStacks(this.stacks));
        return super.func_189515_b(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), this.func_200662_C().hashCode(), this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null) {
                return this.sidedInventoryHandler.cast();
            }
            return this.nonSidedInventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        this.sidedInventoryHandler.invalidate();
        this.nonSidedInventoryHandler.invalidate();
        super.func_145843_s();
    }

    boolean blockActivated(PlayerEntity player) {
        assert (this.field_145850_b != null);
        ItemStack itemMainhand = player.func_184614_ca();
        TanningRackRecipe recipe = this.getRecipe(itemMainhand);
        int pos = 0;
        if (((ItemStack)this.stacks.get(pos)).func_190926_b() && ((ItemStack)this.stacks.get(pos + 1)).func_190926_b() && recipe != null) {
            this.stacks.set(pos, (Object)itemMainhand.func_77979_a(1));
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            return true;
        }
        recipe = this.getRecipe((ItemStack)this.stacks.get(pos));
        if (recipe != null && recipe.getTool().test(itemMainhand) && !((ItemStack)this.stacks.get(pos)).func_190926_b()) {
            itemMainhand.func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213361_c(EquipmentSlotType.MAINHAND));
            if (random.nextDouble() < Config.tanningRackFinishChance) {
                this.stacks.set(pos + 1, (Object)recipe.func_77572_b(null));
                this.stacks.set(pos, (Object)ItemStack.field_190927_a);
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            }
            return true;
        }
        if (itemMainhand.func_190926_b() && !((ItemStack)this.stacks.get(pos + 1)).func_190926_b()) {
            NonNullList itemStacks = NonNullList.func_191196_a();
            itemStacks.add((Object)((ItemStack)this.stacks.get(pos + 1)).func_77946_l());
            this.stacks.set(pos + 1, (Object)ItemStack.field_190927_a);
            this.stacks.set(pos, (Object)ItemStack.field_190927_a);
            InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (NonNullList)itemStacks);
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Nullable
    private TanningRackRecipe getRecipe(ItemStack item) {
        assert (this.field_145850_b != null);
        this.tmpItemHandler.setStackInSlot(0, item);
        return this.field_145850_b.func_199532_z().func_215371_a(TanningRackRecipe.tanning_rack, (IInventory)this.tmpItemHandlerWrapper, this.field_145850_b).orElse(null);
    }

    private IItemHandlerModifiable createNonSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                assert (TanningRackTileEntity.this.field_145850_b != null);
                TanningRackTileEntity.this.func_70296_d();
                TanningRackTileEntity.this.field_145850_b.func_184138_a(TanningRackTileEntity.this.func_174877_v(), TanningRackTileEntity.this.func_195044_w(), TanningRackTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    private IItemHandlerModifiable createSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot >= 1) {
                    return super.extractItem(slot, amount, simulate);
                }
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                TanningRackRecipe recipe;
                if (slot < 1 && this.getStackInSlot(slot).func_190926_b() && TanningRackTileEntity.this.field_145850_b != null && (recipe = TanningRackTileEntity.this.getRecipe(stack)) != null) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            protected void onContentsChanged(int slot) {
                assert (TanningRackTileEntity.this.field_145850_b != null);
                TanningRackTileEntity.this.func_70296_d();
                TanningRackTileEntity.this.field_145850_b.func_184138_a(TanningRackTileEntity.this.func_174877_v(), TanningRackTileEntity.this.func_195044_w(), TanningRackTileEntity.this.func_195044_w(), 3);
            }
        };
    }
}

