/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.yanny.age.stone.blocks.TreeStumpTileEntity;
import com.yanny.age.stone.compatibility.top.TopBlockInfoProvider;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemTier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class TreeStumpBlock
extends Block
implements TopBlockInfoProvider {
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0));

    public TreeStumpBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).harvestLevel(ItemTier.WOOD.func_200925_d()).harvestTool(ToolType.AXE).func_200943_b(2.0f));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TreeStumpTileEntity();
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        TreeStumpTileEntity tileEntity;
        if (!worldIn.field_72995_K && (tileEntity = (TreeStumpTileEntity)worldIn.func_175625_s(pos)) != null) {
            tileEntity.onBlockRightClicked(player);
            return;
        }
        super.func_196270_a(state, worldIn, pos, player);
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TreeStumpTileEntity && !worldIn.field_72995_K && handIn == Hand.MAIN_HAND) {
            ((TreeStumpTileEntity)tileentity).blockActivated(player);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_190946_v(BlockState state) {
        return true;
    }

    public float func_180647_a(BlockState state, @Nonnull PlayerEntity player, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TreeStumpTileEntity && ((TreeStumpTileEntity)tileentity).hasTool(player.func_184614_ca())) {
            return 0.0f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    @Override
    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, PlayerEntity playerEntity, World world, BlockState blockState, IProbeHitData iProbeHitData) {
        TreeStumpTileEntity treeStump;
        TileEntity te = world.func_175625_s(iProbeHitData.getPos());
        if (te instanceof TreeStumpTileEntity && !(treeStump = (TreeStumpTileEntity)te).getResult().func_190926_b()) {
            iProbeInfo.horizontal().item(treeStump.getResult()).progress(treeStump.getPerc(), 100, iProbeInfo.defaultProgressStyle().suffix("%"));
        }
    }
}

