/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.blocks;

import com.yanny.age.stone.blocks.IInventoryInterface;
import com.yanny.age.stone.recipes.TreeStumpRecipe;
import com.yanny.age.stone.subscribers.TileEntitySubscriber;
import com.yanny.ages.api.utils.ItemStackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TreeStumpTileEntity
extends TileEntity
implements IInventoryInterface {
    private final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private final IItemHandlerModifiable nonSidedItemHandler = this.createNonSidedInventoryHandler(this.stacks);
    private final LazyOptional<IItemHandlerModifiable> sidedInventoryHandler = LazyOptional.of(() -> this.createSidedInventoryHandler(this.stacks));
    private final LazyOptional<IItemHandlerModifiable> nonSidedInventoryHandler = LazyOptional.of(() -> this.nonSidedItemHandler);
    private final RecipeWrapper inventoryWrapper = new RecipeWrapper(this.nonSidedItemHandler);
    private final IItemHandlerModifiable tmpItemHandler = new ItemStackHandler(1);
    private final RecipeWrapper tmpItemHandlerWrapper = new RecipeWrapper(this.tmpItemHandler);
    private int totalChops = 0;
    private int chopLeft = 0;
    private ItemStack recipeResult = ItemStack.field_190927_a;
    private final List<Ingredient> tools = new ArrayList<Ingredient>();

    public TreeStumpTileEntity() {
        super(TileEntitySubscriber.tree_stump);
    }

    @Override
    @Nonnull
    public IInventory getInventory() {
        return this.inventoryWrapper;
    }

    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT invTag = tag.func_74775_l("inv");
        ItemStackUtils.deserializeStacks((CompoundNBT)invTag, this.stacks);
        this.chopLeft = tag.func_74762_e("chopLeft");
        this.totalChops = tag.func_74762_e("totalChops");
        this.recipeResult = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("result"));
        CompoundNBT toolTag = tag.func_74775_l("tool");
        ItemStackUtils.deserializeIngredients((CompoundNBT)toolTag, this.tools);
        super.func_145839_a(tag);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)ItemStackUtils.serializeStacks(this.stacks));
        tag.func_74768_a("chopLeft", this.chopLeft);
        tag.func_74768_a("totalChops", this.totalChops);
        CompoundNBT resTag = new CompoundNBT();
        this.recipeResult.func_77955_b(resTag);
        tag.func_218657_a("result", (INBT)resTag);
        tag.func_218657_a("tool", (INBT)ItemStackUtils.serializeIngredients(this.tools));
        return super.func_189515_b(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), this.func_200662_C().hashCode(), this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null) {
                return this.sidedInventoryHandler.cast();
            }
            return this.nonSidedInventoryHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        this.sidedInventoryHandler.invalidate();
        this.nonSidedInventoryHandler.invalidate();
        super.func_145843_s();
    }

    void onBlockRightClicked(PlayerEntity player) {
        assert (this.field_145850_b != null);
        if (this.hasTool(player.func_184614_ca())) {
            --this.chopLeft;
            if (this.chopLeft == 0) {
                NonNullList itemStacks = NonNullList.func_191196_a();
                itemStacks.add((Object)this.recipeResult);
                this.stacks.set(0, (Object)ItemStack.field_190927_a);
                InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (NonNullList)itemStacks);
                this.recipeResult = ItemStack.field_190927_a;
                this.tools.clear();
                player.func_184614_ca().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213361_c(EquipmentSlotType.MAINHAND));
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            } else {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187889_gU, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187767_eL, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    void blockActivated(PlayerEntity player) {
        assert (this.field_145850_b != null);
        ItemStack itemStack = player.func_184614_ca();
        TreeStumpRecipe recipe = this.getRecipe(itemStack);
        if (recipe == null) {
            itemStack = player.func_184592_cb();
            recipe = this.getRecipe(itemStack);
        }
        if (((ItemStack)this.stacks.get(0)).func_190926_b() && recipe != null) {
            this.stacks.set(0, (Object)itemStack.func_77979_a(1));
            this.totalChops = recipe.getChopTimes();
            this.chopLeft = recipe.getChopTimes();
            this.recipeResult = recipe.func_77572_b(null);
            this.tools.addAll((Collection<Ingredient>)recipe.getTools());
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            return;
        }
        if (itemStack.func_190926_b() && !((ItemStack)this.stacks.get(0)).func_190926_b()) {
            NonNullList itemStacks = NonNullList.func_191196_a();
            itemStacks.add((Object)((ItemStack)this.stacks.get(0)).func_77946_l());
            this.stacks.set(0, (Object)ItemStack.field_190927_a);
            InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (NonNullList)itemStacks);
            this.recipeResult = ItemStack.field_190927_a;
            this.tools.clear();
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    boolean hasTool(ItemStack toolInHand) {
        return this.tools.stream().anyMatch(ingredient -> ingredient.test(toolInHand));
    }

    ItemStack getResult() {
        return this.recipeResult;
    }

    int getPerc() {
        return (int)(100.0f - (float)this.chopLeft / (float)this.totalChops * 100.0f);
    }

    @Nullable
    private TreeStumpRecipe getRecipe(ItemStack item) {
        assert (this.field_145850_b != null);
        this.tmpItemHandler.setStackInSlot(0, item);
        return this.field_145850_b.func_199532_z().func_215371_a(TreeStumpRecipe.tree_stump, (IInventory)this.tmpItemHandlerWrapper, this.field_145850_b).orElse(null);
    }

    private IItemHandlerModifiable createNonSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                assert (TreeStumpTileEntity.this.field_145850_b != null);
                TreeStumpTileEntity.this.func_70296_d();
                TreeStumpTileEntity.this.field_145850_b.func_184138_a(TreeStumpTileEntity.this.func_174877_v(), TreeStumpTileEntity.this.func_195044_w(), TreeStumpTileEntity.this.func_195044_w(), 3);
            }
        };
    }

    private IItemHandlerModifiable createSidedInventoryHandler(@Nonnull NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                TreeStumpRecipe recipe;
                if (this.getStackInSlot(slot).func_190926_b() && TreeStumpTileEntity.this.field_145850_b != null && (recipe = TreeStumpTileEntity.this.getRecipe(stack)) != null && ((ItemStack)this.stacks.get(0)).func_190926_b()) {
                    TreeStumpTileEntity.this.totalChops = recipe.getChopTimes();
                    TreeStumpTileEntity.this.chopLeft = recipe.getChopTimes();
                    TreeStumpTileEntity.this.recipeResult = recipe.func_77572_b(null);
                    TreeStumpTileEntity.this.tools.addAll(recipe.getTools());
                    TreeStumpTileEntity.this.field_145850_b.func_184138_a(TreeStumpTileEntity.this.func_174877_v(), TreeStumpTileEntity.this.func_195044_w(), TreeStumpTileEntity.this.func_195044_w(), 3);
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            protected void onContentsChanged(int slot) {
                assert (TreeStumpTileEntity.this.field_145850_b != null);
                TreeStumpTileEntity.this.func_70296_d();
                TreeStumpTileEntity.this.field_145850_b.func_184138_a(TreeStumpTileEntity.this.func_174877_v(), TreeStumpTileEntity.this.func_195044_w(), TreeStumpTileEntity.this.func_195044_w(), 3);
            }
        };
    }
}

