/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.client.models;

import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.age.stone.entities.FowlEntity;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelBox;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FowlModel
extends EntityModel<FowlEntity> {
    private final RendererModel body;
    private final RendererModel head;
    private final RendererModel foot1;
    private final RendererModel foot2;
    private final RendererModel wing1;
    private final RendererModel wing2;

    public FowlModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.body = new RendererModel((Model)this);
        this.body.func_78793_a(0.0f, 17.0f, 0.0f);
        this.body.field_78804_l.add(new ModelBox(this.body, 36, 0, -3.0f, -3.0f, -4.0f, 6, 6, 8, 0.0f, false));
        this.body.field_78804_l.add(new ModelBox(this.body, 52, 14, -1.0f, -5.0f, 3.0f, 2, 5, 4, 0.0f, false));
        this.head = new RendererModel((Model)this);
        this.head.func_78793_a(0.0f, 14.0f, -4.0f);
        this.head.field_78804_l.add(new ModelBox(this.head, 22, 0, -2.0f, -5.0f, -2.0f, 4, 7, 3, 0.0f, false));
        this.head.field_78804_l.add(new ModelBox(this.head, 36, 5, -1.0f, -3.0f, -4.0f, 2, 1, 2, 0.0f, false));
        this.foot1 = new RendererModel((Model)this);
        this.foot1.func_78793_a(-1.0f, 20.0f, 0.0f);
        this.foot1.field_78804_l.add(new ModelBox(this.foot1, 60, 0, -1.0f, -1.0f, 0.0f, 1, 5, 1, 0.0f, false));
        this.foot1.field_78804_l.add(new ModelBox(this.foot1, 24, 11, -2.0f, 4.0f, -2.0f, 3, 0, 3, 0.0f, false));
        this.foot2 = new RendererModel((Model)this);
        this.foot2.func_78793_a(1.0f, 20.0f, 0.0f);
        this.foot2.field_78804_l.add(new ModelBox(this.foot2, 60, 0, 0.0f, -1.0f, 0.0f, 1, 5, 1, 0.0f, false));
        this.foot2.field_78804_l.add(new ModelBox(this.foot2, 24, 11, -1.0f, 4.0f, -2.0f, 3, 0, 3, 0.0f, false));
        this.wing1 = new RendererModel((Model)this);
        this.wing1.func_78793_a(3.0f, 15.0f, 0.0f);
        this.wing1.field_78804_l.add(new ModelBox(this.wing1, 0, 0, 0.0f, 0.0f, -3.0f, 1, 4, 5, 0.0f, false));
        this.wing2 = new RendererModel((Model)this);
        this.wing2.func_78793_a(-3.0f, 15.0f, 0.0f);
        this.wing2.field_78804_l.add(new ModelBox(this.wing2, 0, 0, -1.0f, 0.0f, -3.0f, 1, 4, 5, 0.0f, false));
    }

    public void render(FowlEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (this.field_217114_e) {
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)0.75f, (float)0.75f, (float)0.75f);
            GlStateManager.translatef((float)0.0f, (float)0.5f, (float)0.0f);
            this.body.func_78785_a(scale);
            this.head.func_78785_a(scale);
            this.foot1.func_78785_a(scale);
            this.foot2.func_78785_a(scale);
            this.wing1.func_78785_a(scale);
            this.wing2.func_78785_a(scale);
            GlStateManager.popMatrix();
        } else {
            this.body.func_78785_a(scale);
            this.head.func_78785_a(scale);
            this.foot1.func_78785_a(scale);
            this.foot2.func_78785_a(scale);
            this.wing1.func_78785_a(scale);
            this.wing2.func_78785_a(scale);
        }
    }

    public void setRotationAngles(FowlEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.foot1.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.foot2.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.wing1.field_78808_h = -ageInTicks;
        this.wing2.field_78808_h = ageInTicks;
    }
}

