/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.client.models;

import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.age.stone.entities.MouflonEntity;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelBox;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MouflonModel
extends EntityModel<MouflonEntity> {
    private final RendererModel body;
    private final RendererModel head;
    private final RendererModel feet1;
    private final RendererModel feet2;
    private final RendererModel feet3;
    private final RendererModel feet4;

    public MouflonModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.body = new RendererModel((Model)this);
        this.body.func_78793_a(0.0f, 13.0f, 0.0f);
        this.body.field_78804_l.add(new ModelBox(this.body, 0, 23, -4.0f, -6.0f, -7.0f, 8, 7, 15, 0.0f, false));
        this.body.field_78804_l.add(new ModelBox(this.body, 0, 20, -1.0f, -5.0f, 8.0f, 2, 3, 1, 0.0f, false));
        this.head = new RendererModel((Model)this);
        this.head.func_78793_a(0.0f, 7.0f, -7.0f);
        this.head.field_78804_l.add(new ModelBox(this.head, 40, 0, -3.0f, -4.0f, -4.0f, 6, 5, 6, 0.0f, false));
        this.feet1 = new RendererModel((Model)this);
        this.feet1.func_78793_a(2.0f, 14.0f, -5.0f);
        this.feet1.field_78804_l.add(new ModelBox(this.feet1, 0, 0, -1.0f, 0.0f, -1.0f, 2, 10, 2, 0.0f, false));
        this.feet2 = new RendererModel((Model)this);
        this.feet2.func_78793_a(2.0f, 14.0f, 6.0f);
        this.feet2.field_78804_l.add(new ModelBox(this.feet2, 0, 0, -1.0f, 0.0f, -1.0f, 2, 10, 2, 0.0f, false));
        this.feet3 = new RendererModel((Model)this);
        this.feet3.func_78793_a(-2.0f, 14.0f, 6.0f);
        this.feet3.field_78804_l.add(new ModelBox(this.feet3, 0, 0, -1.0f, 0.0f, -1.0f, 2, 10, 2, 0.0f, false));
        this.feet4 = new RendererModel((Model)this);
        this.feet4.func_78793_a(-2.0f, 14.0f, -5.0f);
        this.feet4.field_78804_l.add(new ModelBox(this.feet4, 0, 0, -1.0f, 0.0f, -1.0f, 2, 10, 2, 0.0f, false));
    }

    public void render(MouflonEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.setRotationAngles(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        if (this.field_217114_e) {
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)0.75f, (float)0.75f, (float)0.75f);
            GlStateManager.translatef((float)0.0f, (float)0.5f, (float)0.0f);
            this.body.func_78785_a(scale);
            this.head.func_78785_a(scale);
            this.feet1.func_78785_a(scale);
            this.feet2.func_78785_a(scale);
            this.feet3.func_78785_a(scale);
            this.feet4.func_78785_a(scale);
            GlStateManager.popMatrix();
        } else {
            this.body.func_78785_a(scale);
            this.head.func_78785_a(scale);
            this.feet1.func_78785_a(scale);
            this.feet2.func_78785_a(scale);
            this.feet3.func_78785_a(scale);
            this.feet4.func_78785_a(scale);
        }
    }

    public void setRotationAngles(MouflonEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.feet1.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.feet2.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.feet3.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.feet4.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }
}

