/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.age.stone.blocks.DriedGrassBedTileEntity;
import com.yanny.age.stone.client.models.DriedGrassBedModel;
import com.yanny.age.stone.subscribers.ItemSubscriber;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DriedGrassBedRenderer
extends TileEntityRenderer<DriedGrassBedTileEntity> {
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("stone_age", "textures/entity/dried_grass_bed.png");
    private static final ItemStack GRASS = new ItemStack((IItemProvider)ItemSubscriber.dried_grass);
    private final DriedGrassBedModel model = new DriedGrassBedModel();

    public void render(DriedGrassBedTileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        if (tileEntityIn.func_145830_o()) {
            BlockState blockstate = tileEntityIn.func_195044_w();
            this.render(blockstate.func_177229_b((IProperty)BedBlock.field_176472_a) == BedPart.HEAD, x, y, z, (Direction)blockstate.func_177229_b((IProperty)BedBlock.field_185512_D));
        } else {
            this.render(true, x, y, z + 0.5, Direction.SOUTH);
            this.render(false, x, y, z - 0.5, Direction.SOUTH);
        }
    }

    private void render(boolean isHead, double x, double y, double z, Direction direction) {
        if (isHead) {
            this.model.setVisibleHead();
        } else {
            this.model.setVisibleFoot();
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        switch (direction) {
            case NORTH: {
                GlStateManager.rotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.rotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.0f, (float)0.09375f, (float)0.0f);
        this.func_147499_a(TEXTURE_NORMAL);
        this.model.render();
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.scalef((float)0.749f, (float)0.749f, (float)0.749f);
        if (isHead) {
            GlStateManager.rotatef((float)-85.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.translatef((float)0.5f, (float)0.75f, (float)0.0325f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(GRASS, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.scalef((float)0.749f, (float)0.749f, (float)0.749f);
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)-85.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.translatef((float)0.5f, (float)0.75f, (float)0.0325f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(GRASS, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.scalef((float)0.749f, (float)0.749f, (float)0.749f);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)-85.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.translatef((float)0.5f, (float)0.75f, (float)0.0325f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(GRASS, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.scalef((float)0.749f, (float)0.749f, (float)0.749f);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)-85.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.translatef((float)1.1666666f, (float)0.75f, (float)0.03251f);
        } else {
            GlStateManager.rotatef((float)85.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.translatef((float)0.5f, (float)0.75f, (float)0.9675f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(GRASS, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.scalef((float)0.749f, (float)0.749f, (float)0.749f);
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)85.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.translatef((float)0.5f, (float)0.75f, (float)0.9675f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(GRASS, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.scalef((float)0.749f, (float)0.749f, (float)0.749f);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)85.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.translatef((float)0.5f, (float)0.75f, (float)0.9675f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(GRASS, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.scalef((float)0.749f, (float)0.749f, (float)0.749f);
            GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.rotatef((float)85.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.translatef((float)-0.1666666f, (float)0.75f, (float)0.96751f);
        }
        Minecraft.func_71410_x().func_175599_af().func_181564_a(GRASS, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }
}

