/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.age.stone.blocks.FlintWorkbenchTileEntity;
import com.yanny.ages.api.utils.ItemStackUtils;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlintWorkbenchRenderer
extends TileEntityRenderer<FlintWorkbenchTileEntity> {
    public void render(FlintWorkbenchTileEntity tileEntityIn, double dx, double dy, double dz, float partialTicks, int destroyStage) {
        Direction direction = (Direction)tileEntityIn.func_195044_w().func_177229_b((IProperty)HorizontalBlock.field_185512_D);
        float border = 0.0625f;
        float part = (1.0f - 4.0f * border) / 3.0f;
        float t = border + part / 2.0f;
        float off = part + border;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int x = 0;
                int y = 0;
                switch (direction) {
                    case NORTH: {
                        x = 2 - j;
                        y = 2 - i;
                        break;
                    }
                    case SOUTH: {
                        x = j;
                        y = i;
                        break;
                    }
                    case WEST: {
                        x = 2 - i;
                        y = j;
                        break;
                    }
                    case EAST: {
                        x = i;
                        y = 2 - j;
                    }
                }
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)((float)dx + off * (float)x + t), (float)((float)dy + 0.125f), (float)((float)dz + off * (float)y + t));
                switch (direction) {
                    case SOUTH: {
                        GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case WEST: {
                        GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case EAST: {
                        GlStateManager.rotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
                GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.scalef((float)0.25f, (float)0.25f, (float)0.25f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(tileEntityIn.getInventory().func_70301_a(i * 3 + j), ItemCameraTransforms.TransformType.FIXED);
                GlStateManager.popMatrix();
            }
        }
        if (!tileEntityIn.getRecipeOutput().func_190926_b()) {
            GlStateManager.pushMatrix();
            switch (direction) {
                case NORTH: {
                    GlStateManager.translatef((float)((float)dx + 0.5f), (float)((float)dy + 0.4f), (float)((float)dz + 0.95f));
                    break;
                }
                case SOUTH: {
                    GlStateManager.translatef((float)((float)dx + 0.5f), (float)((float)dy + 0.4f), (float)((float)dz + 0.05f));
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.translatef((float)((float)dx + 0.95f), (float)((float)dy + 0.4f), (float)((float)dz + 0.5f));
                    GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GlStateManager.translatef((float)((float)dx + 0.05f), (float)((float)dy + 0.4f), (float)((float)dz + 0.5f));
                    GlStateManager.rotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            ItemStackUtils.renderItem((ItemStack)tileEntityIn.getRecipeOutput(), (float)0.6f, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.popMatrix();
        }
    }
}

