/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.yanny.age.stone.blocks.StoneChestBlock;
import com.yanny.age.stone.blocks.StoneChestTileEntity;
import com.yanny.age.stone.client.models.StoneChestModel;
import com.yanny.age.stone.subscribers.BlockSubscriber;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StoneChestRenderer
extends TileEntityRenderer<StoneChestTileEntity> {
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("stone_age", "textures/entity/stone_chest.png");
    private final StoneChestModel model = new StoneChestModel();

    public void render(StoneChestTileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        BlockState blockstate = tileEntityIn.func_145830_o() ? tileEntityIn.func_195044_w() : (BlockState)BlockSubscriber.stone_chest.func_176223_P().func_206870_a((IProperty)StoneChestBlock.field_185512_D, (Comparable)Direction.SOUTH);
        StoneChestModel chestModel = this.getChestModel(destroyStage);
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.translatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        float f = ((Direction)blockstate.func_177229_b((IProperty)StoneChestBlock.field_185512_D)).func_185119_l();
        if ((double)Math.abs(f) > 1.0E-5) {
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.rotatef((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }
        GlStateManager.translatef((float)0.5f, (float)-0.5f, (float)0.5f);
        this.applyLidRotation(tileEntityIn, partialTicks, chestModel);
        chestModel.renderAll();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private StoneChestModel getChestModel(int destroyStage) {
        ResourceLocation resourcelocation = destroyStage >= 0 ? field_178460_a[destroyStage] : TEXTURE_NORMAL;
        this.func_147499_a(resourcelocation);
        return this.model;
    }

    private void applyLidRotation(StoneChestTileEntity tileEntity, float angle, StoneChestModel model) {
        float f = tileEntity.func_195480_a(angle);
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        model.getLid().field_78796_g = -(f * 1.5707964f);
    }
}

