/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.compatibility.jei;

import com.google.common.collect.ImmutableList;
import com.yanny.age.stone.recipes.FlintWorkbenchRecipe;
import com.yanny.age.stone.subscribers.BlockSubscriber;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class FlintWorkbenchRecipeCategory
implements IRecipeCategory<FlintWorkbenchRecipe> {
    static final ResourceLocation UID = new ResourceLocation("stone_age", "flint_workbench_recipe_category");
    private final String localizedName;
    private final IDrawableStatic background;
    private final IDrawable icon;

    FlintWorkbenchRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = new ResourceLocation("stone_age", "textures/gui/jei/gui_layouts.png");
        this.background = guiHelper.createDrawable(location, 0, 0, 120, 60);
        this.localizedName = I18n.func_135052_a((String)"block.stone_age.flint_workbench", (Object[])new Object[0]);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BlockSubscriber.flint_workbench));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends FlintWorkbenchRecipe> getRecipeClass() {
        return FlintWorkbenchRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull FlintWorkbenchRecipe flintWorkbenchRecipe, @Nonnull IIngredients ingredients) {
        ImmutableList.Builder inputBuilder = ImmutableList.builder();
        ImmutableList.Builder outputBuilder = ImmutableList.builder();
        int width = flintWorkbenchRecipe.getWidth();
        int height = flintWorkbenchRecipe.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                inputBuilder.add(Arrays.asList(((Ingredient)flintWorkbenchRecipe.func_192400_c().get(x + y * width)).func_193365_a()));
            }
        }
        inputBuilder.add(Arrays.asList(flintWorkbenchRecipe.getTool().func_193365_a()));
        outputBuilder.add((Object)flintWorkbenchRecipe.func_77571_b());
        ingredients.setInputLists(VanillaTypes.ITEM, (List)inputBuilder.build());
        ingredients.setOutputLists(VanillaTypes.ITEM, (List)ImmutableList.of((Object)outputBuilder.build()));
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull FlintWorkbenchRecipe flintWorkbenchRecipe, @Nonnull IIngredients ingredients) {
        int width = flintWorkbenchRecipe.getWidth();
        int height = flintWorkbenchRecipe.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                recipeLayout.getItemStacks().init(x + y * width, true, 3 + x * 18, 3 + y * 18);
                recipeLayout.getItemStacks().set(x + y * width, (List)ingredients.getInputs(VanillaTypes.ITEM).get(x + y * width));
            }
        }
        recipeLayout.getItemStacks().init(width * height, false, 97, 21);
        recipeLayout.getItemStacks().set(width * height, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(width * height + 1, false, 66, 20);
        recipeLayout.getItemStacks().set(width * height + 1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(width * height));
    }
}

