/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.entities;

import com.yanny.age.stone.entities.IBecomeAngry;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Difficulty;

class AgroTargetGoal
extends TargetGoal {
    private static final EntityPredicate predicate = new EntityPredicate().func_221014_c().func_221010_e();
    private int revengeTimerOld;
    private final Class<? extends IBecomeAngry> reinforcement;
    private final Class<?>[] excludedReinforcementTypes;

    AgroTargetGoal(CreatureEntity creatureIn, Class<? extends IBecomeAngry> reinforcement, Class<?> ... excludeReinforcement) {
        super((MobEntity)creatureIn, true);
        this.reinforcement = reinforcement;
        this.excludedReinforcementTypes = excludeReinforcement;
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean func_75250_a() {
        int i = this.field_75299_d.func_142015_aE();
        LivingEntity livingentity = this.field_75299_d.func_70643_av();
        if (i != this.revengeTimerOld && livingentity != null) {
            for (Class<?> oclass : this.excludedReinforcementTypes) {
                if (!oclass.isAssignableFrom(livingentity.getClass())) continue;
                return false;
            }
            return this.func_220777_a(livingentity, predicate) && this.field_75299_d.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL;
        }
        return false;
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.field_75299_d.func_70643_av());
        this.field_188509_g = this.field_75299_d.func_70638_az();
        this.revengeTimerOld = this.field_75299_d.func_142015_aE();
        this.field_188510_h = 300;
        this.alertOthers();
        super.func_75249_e();
    }

    private void alertOthers() {
        double d0 = this.func_111175_f();
        List list = this.field_75299_d.field_70170_p.func_225317_b(this.field_75299_d.getClass(), new AxisAlignedBB(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u, this.field_75299_d.field_70161_v, this.field_75299_d.field_70165_t + 1.0, this.field_75299_d.field_70163_u + 1.0, this.field_75299_d.field_70161_v + 1.0).func_72314_b(d0, 10.0, d0));
        for (MobEntity mobentity : list) {
            if (this.field_75299_d == mobentity || mobentity.func_70638_az() != null || this.field_75299_d instanceof TameableEntity && ((TameableEntity)this.field_75299_d).func_70902_q() != ((TameableEntity)mobentity).func_70902_q() || mobentity.func_184191_r((Entity)Objects.requireNonNull(this.field_75299_d.func_70643_av()))) continue;
            boolean flag = false;
            if (mobentity.getClass() == this.reinforcement) {
                flag = true;
            }
            if (!flag) break;
            this.setAttackTarget(mobentity, this.field_75299_d.func_70643_av());
        }
    }

    private void setAttackTarget(MobEntity mobIn, LivingEntity targetIn) {
        if (this.reinforcement.isAssignableFrom(mobIn.getClass()) && this.field_75299_d.func_70685_l((Entity)targetIn) && this.reinforcement.cast(mobIn).becomeAngryAt((Entity)targetIn)) {
            mobIn.func_70624_b(targetIn);
        }
    }
}

