/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.entities;

import com.yanny.age.stone.entities.BoarEntity;
import com.yanny.age.stone.entities.IBecomeAngry;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

abstract class WildAnimalEntity
extends AnimalEntity
implements IBecomeAngry {
    static final DataParameter<Integer> GENERATION = EntityDataManager.func_187226_a(BoarEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int angerLevel;
    private UUID angerTargetUUID;

    WildAnimalEntity(EntityType<? extends AnimalEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public void func_70619_bc() {
        LivingEntity livingentity = this.func_70638_az();
        if (livingentity != null && this.func_70068_e((Entity)livingentity) < 16.0) {
            this.calculateRotationYaw(livingentity.field_70165_t, livingentity.field_70161_v);
            this.field_70765_h.func_75642_a(livingentity.field_70165_t, livingentity.field_70163_u, livingentity.field_70161_v, this.field_70765_h.func_75638_b());
        }
        if (this.isAngry()) {
            --this.angerLevel;
            if (!this.isAngry()) {
                this.func_70604_c(null);
                this.func_70624_b(null);
                this.field_70714_bg.func_220888_c().forEach(PrioritizedGoal::func_75251_c);
            }
        }
        if (this.isAngry() && this.angerTargetUUID != null && livingentity == null) {
            PlayerEntity playerentity = this.field_70170_p.func_217371_b(this.angerTargetUUID);
            this.func_70604_c((LivingEntity)playerentity);
            this.field_70717_bb = playerentity;
            this.field_70718_bc = this.func_142015_aE();
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof PlayerEntity && !((PlayerEntity)entity).func_184812_l_() && this.func_70685_l(entity)) {
            this.becomeAngryAt(entity);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74777_a("Anger", (short)this.angerLevel);
        compound.func_74768_a("Generation", ((Integer)this.field_70180_af.func_187225_a(GENERATION)).intValue());
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.angerLevel = compound.func_74765_d("Anger");
        this.setGeneration(compound.func_74762_e("Generation"));
        String s = compound.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            PlayerEntity playerentity = this.field_70170_p.func_217371_b(this.angerTargetUUID);
            this.func_70604_c((LivingEntity)playerentity);
            if (playerentity != null) {
                this.field_70717_bb = playerentity;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GENERATION, (Object)0);
    }

    public void func_70604_c(@Nullable LivingEntity livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    @Override
    public boolean becomeAngryAt(Entity entity) {
        this.angerLevel = this.nextRand();
        if (entity instanceof LivingEntity) {
            this.func_70604_c((LivingEntity)entity);
        }
        return true;
    }

    @Override
    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    void setGeneration(int generation) {
        this.field_70180_af.func_187227_b(GENERATION, (Object)generation);
    }

    private int nextRand() {
        return 100 + this.field_70146_Z.nextInt(100);
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.2957763671875) - 90.0f;
    }
}

