/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.handlers;

import com.google.common.collect.Sets;
import com.yanny.ages.api.capability.fluid.GenericFluidEntityHandler;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AqueductHandler {
    private static final int VERSION = 1;
    private static final String ID = "stone_age_aqueduct_handler";
    private static final GenericFluidEntityHandler.Setup SETUP = new AqueductSetup();
    private static final HashMap<World, GenericFluidEntityHandler> INSTANCE = new HashMap();

    @Nonnull
    public static GenericFluidEntityHandler getInstance(@Nonnull World world) {
        if (world.field_72995_K) {
            throw new IllegalStateException("stone_age_aqueduct_handler is only server-side");
        }
        GenericFluidEntityHandler handler = INSTANCE.get(world);
        if (handler == null) {
            handler = new GenericFluidEntityHandler(world, SETUP);
            INSTANCE.put(world, handler);
        }
        if (world instanceof ServerWorld) {
            ServerWorld server = (ServerWorld)world;
            server.func_217481_x().func_215752_a(() -> INSTANCE.get(world), ID);
        }
        return handler;
    }

    private static final class AqueductSetup
    extends GenericFluidEntityHandler.Setup {
        private static final Set<Direction> DIRECTIONS = Sets.newHashSet((Iterable)Direction.Plane.HORIZONTAL);

        AqueductSetup() {
            super(500, AqueductHandler.ID, DIRECTIONS, 1);
        }

        public boolean checkConnection(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction posFacing, @Nonnull BlockPos pos2) {
            return true;
        }
    }
}

