/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.recipes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.yanny.age.stone.recipes.FlintWorkbenchRecipe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FlintWorkbenchRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<FlintWorkbenchRecipe> {
    @Nonnull
    public FlintWorkbenchRecipe read(@Nonnull ResourceLocation recipeID, @Nonnull JsonObject json) {
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        Map<String, Ingredient> map = FlintWorkbenchRecipeSerializer.deserializeKey(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
        String[] astring = FlintWorkbenchRecipeSerializer.shrink(FlintWorkbenchRecipeSerializer.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
        int i = astring[0].length();
        int j = astring.length;
        NonNullList<Ingredient> nonnulllist = FlintWorkbenchRecipeSerializer.deserializeIngredients(astring, map, i, j);
        ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        Ingredient tool = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"tool"));
        return new FlintWorkbenchRecipe(recipeID, s, i, j, tool, nonnulllist, itemstack);
    }

    public FlintWorkbenchRecipe read(@Nonnull ResourceLocation recipeID, PacketBuffer buffer) {
        int width = buffer.func_150792_a();
        int height = buffer.func_150792_a();
        String group = buffer.func_150789_c(Short.MAX_VALUE);
        NonNullList ingredients = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack result = buffer.func_150791_c();
        Ingredient tool = Ingredient.func_199566_b((PacketBuffer)buffer);
        return new FlintWorkbenchRecipe(recipeID, group, width, height, tool, (NonNullList<Ingredient>)ingredients, result);
    }

    public void write(PacketBuffer buffer, FlintWorkbenchRecipe recipe) {
        buffer.func_150787_b(recipe.getWidth());
        buffer.func_150787_b(recipe.getHeight());
        buffer.func_180714_a(recipe.func_193358_e());
        for (Ingredient ingredient : recipe.func_192400_c()) {
            ingredient.func_199564_a(buffer);
        }
        buffer.func_150788_a(recipe.func_77571_b());
        recipe.getTool().func_199564_a(buffer);
    }

    private static Map<String, Ingredient> deserializeKey(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    private static String[] shrink(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, FlintWorkbenchRecipeSerializer.firstNonSpace(s));
            int j1 = FlintWorkbenchRecipeSerializer.lastNonSpace(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    private static String[] patternFromJson(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }
}

