/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.yanny.age.stone.recipes.MillstoneRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MillstoneRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<MillstoneRecipe> {
    private final IFactory<MillstoneRecipe> factory;

    public MillstoneRecipeSerializer(IFactory<MillstoneRecipe> factory) {
        this.factory = factory;
    }

    @Nonnull
    public MillstoneRecipe read(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        ItemStack itemstack;
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        } else {
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_218349_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
        }
        int activateCount = JSONUtils.func_151203_m((JsonObject)json, (String)"activateCount");
        return this.factory.create(recipeId, s, ingredient, itemstack, activateCount);
    }

    @Nullable
    public MillstoneRecipe read(@Nonnull ResourceLocation recipeId, PacketBuffer buffer) {
        String s = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack itemstack = buffer.func_150791_c();
        int activateCount = buffer.readInt();
        return this.factory.create(recipeId, s, ingredient, itemstack, activateCount);
    }

    public void write(PacketBuffer buffer, MillstoneRecipe recipe) {
        buffer.func_180714_a(recipe.group);
        recipe.ingredient.func_199564_a(buffer);
        buffer.func_150788_a(recipe.result);
        buffer.writeInt(recipe.activateCount);
    }

    public static interface IFactory<T extends MillstoneRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, int var5);
    }
}

