/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.age.stone.structures;

import com.yanny.age.stone.blocks.DryingRackTileEntity;
import com.yanny.age.stone.blocks.FlintWorkbenchTileEntity;
import com.yanny.age.stone.blocks.StoneChestTileEntity;
import com.yanny.age.stone.blocks.TanningRackTileEntity;
import com.yanny.age.stone.subscribers.BlockSubscriber;
import com.yanny.age.stone.subscribers.ItemSubscriber;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.ScatteredStructurePiece;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BasePiece
extends ScatteredStructurePiece {
    protected static final Logger LOGGER = LogManager.getLogger();

    protected BasePiece(IStructurePieceType structurePieceTypeIn, Random rand, int xIn, int yIn, int zIn, int widthIn, int heightIn, int depthIn) {
        super(structurePieceTypeIn, rand, xIn, yIn, zIn, widthIn, heightIn, depthIn);
    }

    protected BasePiece(IStructurePieceType structurePieceTypeIn, CompoundNBT nbt) {
        super(structurePieceTypeIn, nbt);
    }

    protected void generateStoneChest(@Nonnull IWorld worldIn, MutableBoundingBox boundsIn, @Nonnull Random rand, int x, int y, int z, @Nonnull ResourceLocation lootResource, Direction direction) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (boundsIn.func_175898_b((Vec3i)blockpos)) {
            worldIn.func_180501_a(blockpos, (BlockState)BlockSubscriber.stone_chest.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)direction), 2);
            TileEntity tileentity = worldIn.func_175625_s(blockpos);
            if (tileentity instanceof StoneChestTileEntity) {
                ((StoneChestTileEntity)tileentity).func_189404_a(lootResource, rand.nextLong());
            }
        }
    }

    protected void generateFlintWorkbench(@Nonnull IWorld worldIn, MutableBoundingBox boundsIn, @Nonnull Random rand, int x, int y, int z, Direction direction) {
        BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
        if (boundsIn.func_175898_b((Vec3i)blockpos)) {
            this.func_175811_a(worldIn, (BlockState)BlockSubscriber.flint_workbench.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)direction), x, y, z, boundsIn);
            TileEntity tileentity = worldIn.func_175625_s(blockpos);
            if (tileentity instanceof FlintWorkbenchTileEntity) {
                NonNullList<ItemStack> stacks = ((FlintWorkbenchTileEntity)tileentity).getStacks();
                for (int i = 0; i < stacks.size(); ++i) {
                    if (!(rand.nextDouble() < 0.25)) continue;
                    stacks.set(i, (Object)new ItemStack((IItemProvider)ItemSubscriber.antler));
                }
            }
        }
    }

    protected void generateRandomRack(@Nonnull IWorld worldIn, MutableBoundingBox boundsIn, @Nonnull Random random, int x, int y, int z, Direction direction) {
        block3: {
            BlockPos blockpos;
            block4: {
                blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
                if (!boundsIn.func_175898_b((Vec3i)blockpos)) break block3;
                if (!(random.nextDouble() < 0.5)) break block4;
                this.func_175811_a(worldIn, (BlockState)BlockSubscriber.drying_rack.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)direction), x, y, z, boundsIn);
                TileEntity tileentity = worldIn.func_175625_s(blockpos);
                if (!(tileentity instanceof DryingRackTileEntity)) break block3;
                NonNullList<ItemStack> stacks = ((DryingRackTileEntity)tileentity).getStacks();
                for (int i = stacks.size() / 2; i < stacks.size(); ++i) {
                    if (!(random.nextDouble() < 0.5)) continue;
                    stacks.set(i, (Object)new ItemStack((IItemProvider)ItemSubscriber.dried_grass));
                }
                break block3;
            }
            this.func_175811_a(worldIn, (BlockState)BlockSubscriber.tanning_rack.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208157_J, (Comparable)direction), x, y, z, boundsIn);
            TileEntity tileentity = worldIn.func_175625_s(blockpos);
            if (tileentity instanceof TanningRackTileEntity) {
                NonNullList<ItemStack> stacks = ((TanningRackTileEntity)tileentity).getStacks();
                for (int i = 0; i < stacks.size() / 2; ++i) {
                    if (!(random.nextDouble() < 0.7)) continue;
                    stacks.set(i, (Object)new ItemStack((IItemProvider)ItemSubscriber.raw_hide));
                }
            }
        }
    }

    protected void replaceAirAndLiquidDownwards(@Nonnull IWorld worldIn, MutableBoundingBox boundingboxIn, int x, int y, int z, @Nonnull BlockState blockstateIn) {
        int k;
        int j;
        int i = this.func_74865_a(x, z);
        if (boundingboxIn.func_175898_b((Vec3i)new BlockPos(i, j = this.func_74862_a(y), k = this.func_74873_b(x, z)))) {
            while (this.isNotSolid(worldIn, new BlockPos(i, j, k)) && j > 1) {
                worldIn.func_180501_a(new BlockPos(i, j, k), blockstateIn, 2);
                --j;
            }
        }
    }

    private boolean isNotSolid(IWorld worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        return worldIn.func_175623_d(pos) || state.func_185904_a().func_76224_d() || state.func_185904_a().func_76222_j() || state.func_185904_a().equals(Material.field_151595_p) || state.func_185904_a().equals(Material.field_151578_c) || state.func_185904_a().equals(Material.field_151577_b);
    }
}

