/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client;

import com.mrbysco.structurecompass.client.screen.CompassScreen;
import com.mrbysco.structurecompass.init.StructureItems;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientHandler {
    public static void onClientSetup(FMLClientSetupEvent event) {
        ItemModelsProperties.func_239418_a_((Item)((Item)StructureItems.STRUCTURE_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (IItemPropertyGetter)new IItemPropertyGetter(){
            @OnlyIn(value=Dist.CLIENT)
            private double rotation;
            @OnlyIn(value=Dist.CLIENT)
            private double rota;
            @OnlyIn(value=Dist.CLIENT)
            private long lastUpdateTick;

            @OnlyIn(value=Dist.CLIENT)
            public float call(ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity livingBaseIn) {
                double d0;
                LivingEntity entity;
                if (livingBaseIn == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean livingExists = livingBaseIn != null;
                Object object = entity = livingExists ? livingBaseIn : stack.func_82836_z();
                if (worldIn == null && entity.field_70170_p instanceof ClientWorld) {
                    worldIn = (ClientWorld)entity.field_70170_p;
                }
                if (worldIn.func_230315_m_().func_236043_f_()) {
                    double d1 = livingExists ? (double)entity.field_70177_z : this.getFrameRotation((ItemFrameEntity)entity);
                    d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                    double d2 = this.getSpawnToAngle(worldIn, (Entity)entity, stack) / 6.2831854820251465;
                    d0 = 0.5 - (d1 - 0.25 - d2);
                } else {
                    d0 = Math.random();
                }
                if (livingExists) {
                    d0 = this.wobble(worldIn, d0);
                }
                return MathHelper.func_188207_b((float)((float)d0), (float)1.0f);
            }

            @OnlyIn(value=Dist.CLIENT)
            private double wobble(ClientWorld worldIn, double p_185093_2_) {
                if (worldIn.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = worldIn.func_82737_E();
                    double d0 = p_185093_2_ - this.rotation;
                    d0 = MathHelper.func_191273_b((double)(d0 + 0.5), (double)1.0) - 0.5;
                    this.rota += d0 * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getFrameRotation(ItemFrameEntity itemFrame) {
                Direction direction = itemFrame.func_174811_aO();
                int i = direction.func_176740_k().func_200128_b() ? 90 * direction.func_176743_c().func_179524_a() : 0;
                return MathHelper.func_188209_b((int)(180 + direction.func_176736_b() * 90 + itemFrame.func_82333_j() * 45 + i));
            }

            @OnlyIn(value=Dist.CLIENT)
            private double getSpawnToAngle(ClientWorld worldIn, Entity entityIn, ItemStack stack) {
                BlockPos pos = this.getBlockPos(stack, worldIn);
                return Math.atan2((double)pos.func_177952_p() - entityIn.func_226281_cx_(), (double)pos.func_177958_n() - entityIn.func_226277_ct_());
            }

            public BlockPos getBlockPos(ItemStack stack, ClientWorld world) {
                CompoundNBT tag;
                if (stack.func_77942_o() && (tag = stack.func_77978_p()) != null && tag.func_74764_b("structurecompass:structureFound") && tag.func_74767_n("structurecompass:structureFound")) {
                    long structureLong = tag.func_74763_f("structurecompass:structurePosition");
                    return BlockPos.func_218283_e((long)structureLong);
                }
                return world.func_230315_m_().func_236043_f_() ? world.func_239140_u_() : null;
            }
        });
    }

    public static void openStructureScreen(PlayerEntity playerIn, Hand hand, ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CompassScreen(playerIn, hand, stack));
    }
}

