/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrbysco.structurecompass.client.screen.widget.StructureListWidget;
import com.mrbysco.structurecompass.compat.gamestages.GameStagesHelper;
import com.mrbysco.structurecompass.network.PacketHandler;
import com.mrbysco.structurecompass.network.message.SetStructureMessage;
import com.mrbysco.structurecompass.util.StructureUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.network.PacketDistributor;

public class CompassScreen
extends Screen {
    private static final int PADDING = 6;
    private StructureListWidget structureWidget;
    private StructureListWidget.ListEntry selected = null;
    private int listWidth;
    private List<ResourceLocation> structures;
    private final List<ResourceLocation> unsortedStructures;
    private Button loadButton;
    private final PlayerEntity editingPlayer;
    private final Hand usedHand;
    private final ItemStack compassStack;
    private int buttonMargin = 1;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private TextFieldWidget search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public CompassScreen(PlayerEntity player, Hand hand, ItemStack compass) {
        super((ITextComponent)new TranslationTextComponent("structurecompass:compass.screen"));
        this.editingPlayer = player;
        this.usedHand = hand;
        this.compassStack = compass;
        List<ResourceLocation> allStructures = StructureUtil.getAvailableStructureList();
        ArrayList<ResourceLocation> structureList = new ArrayList<ResourceLocation>();
        for (ResourceLocation id : allStructures) {
            if (id == null) continue;
            structureList.add(id);
        }
        if (ModList.get().isLoaded("gamestages")) {
            structureList.removeIf(location -> !GameStagesHelper.doesPlayerHaveRequiredStage(this.editingPlayer, location));
        }
        Collections.sort(structureList);
        this.structures = Collections.unmodifiableList(structureList);
        this.unsortedStructures = Collections.unmodifiableList(allStructures);
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_231160_c_() {
        int centerWidth = this.field_230708_k_ / 2;
        for (ResourceLocation structureLocation : this.structures) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(structureLocation.toString()) + 10);
        }
        this.listWidth = Math.max(Math.min(this.listWidth, this.field_230708_k_ / 3), 200);
        this.listWidth += this.listWidth % this.numButtons != 0 ? this.numButtons - this.listWidth % this.numButtons : 0;
        int structureWidth = this.field_230708_k_ - this.listWidth - 18;
        int closeButtonWidth = Math.min(structureWidth, 200);
        int y = this.field_230709_l_ - 20 - 6;
        this.func_230480_a_((Widget)new Button(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), b -> this.func_231175_as__()));
        this.loadButton = new Button(centerWidth - closeButtonWidth / 2 + 6, y -= 24, closeButtonWidth, 20, (ITextComponent)new TranslationTextComponent("structurecompass.screen.selection.load"), b -> {
            if (this.selected != null) {
                PacketHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new SetStructureMessage(this.usedHand, this.selected.getStructureLocation()));
            }
        });
        this.func_230480_a_((Widget)this.loadButton);
        this.search = new TextFieldWidget(this.getFontRenderer(), centerWidth - this.listWidth / 2 + 6 + 1, y -= 20, this.listWidth - 2, 14, (ITextComponent)new TranslationTextComponent("structurecompass.screen.search"));
        int fullButtonHeight = 32;
        int n = this.search.field_230691_m_;
        this.getFontRenderer().getClass();
        this.structureWidget = new StructureListWidget(this, this.field_230708_k_, fullButtonHeight, n - 9 - 6);
        this.structureWidget.func_230959_g_(0);
        this.field_230705_e_.add(this.search);
        this.field_230705_e_.add(this.structureWidget);
        this.search.func_146195_b(false);
        this.search.func_146205_d(true);
        if (this.compassStack.func_77942_o() && this.compassStack.func_77978_p().func_74764_b("structurecompass:structureName")) {
            String structure = this.compassStack.func_77978_p().func_74779_i("structurecompass:structureName");
            this.search.func_146180_a(structure);
        }
        int width = this.listWidth / this.numButtons;
        int x = centerWidth + 6 - width;
        SortType.A_TO_Z.button = new Button(x, 6, width - this.buttonMargin, 20, SortType.A_TO_Z.getButtonText(), b -> this.resortStructures(SortType.A_TO_Z));
        this.func_230480_a_((Widget)SortType.A_TO_Z.button);
        SortType.Z_TO_A.button = new Button(x += width + this.buttonMargin, 6, width - this.buttonMargin, 20, SortType.Z_TO_A.getButtonText(), b -> this.resortStructures(SortType.Z_TO_A));
        this.func_230480_a_((Widget)SortType.Z_TO_A.button);
        this.resortStructures(SortType.A_TO_Z);
        this.updateCache();
    }

    public void func_231023_e_() {
        this.search.func_146178_a();
        this.structureWidget.func_241215_a_((AbstractList.AbstractListEntry)this.selected);
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.reloadStructures();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadStructures();
            if (this.sortType == SortType.A_TO_Z) {
                Collections.sort(this.structures);
            } else if (this.sortType == SortType.Z_TO_A) {
                Collections.sort(this.structures, Collections.reverseOrder());
            }
            this.checkStages();
            this.structureWidget.refreshList();
            if (this.selected != null) {
                this.selected = this.structureWidget.func_231039_at__().stream().filter(e -> e == this.selected).findFirst().orElse(null);
                this.updateCache();
            }
            this.sorted = true;
        }
    }

    public <T extends ExtendedList.AbstractListEntry<T>> void buildStructureList(Consumer<T> ListViewConsumer, Function<ResourceLocation, T> newEntry) {
        this.structures.forEach(mod -> ListViewConsumer.accept(newEntry.apply((ResourceLocation)mod)));
    }

    private void reloadStructures() {
        this.structures = this.unsortedStructures.stream().filter(struc -> StringUtils.toLowerCase((String)struc.toString()).contains(StringUtils.toLowerCase((String)this.search.func_146179_b()))).collect(Collectors.toList());
        this.checkStages();
        this.lastFilterText = this.search.func_146179_b();
    }

    private void checkStages() {
        if (ModList.get().isLoaded("gamestages")) {
            this.structures.removeIf(location -> !GameStagesHelper.doesPlayerHaveRequiredStage(this.editingPlayer, location));
        }
    }

    private void resortStructures(SortType newSort) {
        this.sortType = newSort;
        for (SortType sort : SortType.values()) {
            if (sort.button == null) continue;
            sort.button.field_230693_o_ = this.sortType != sort;
        }
        this.sorted = false;
    }

    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.structureWidget.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        TranslationTextComponent text = new TranslationTextComponent("structurecompass.screen.search");
        FontRenderer fontRenderer = this.getFontRenderer();
        int n = this.field_230708_k_ / 2 + 6;
        int n2 = this.search.field_230691_m_;
        this.getFontRenderer().getClass();
        CompassScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)fontRenderer, (ITextComponent)text, (int)n, (int)(n2 - 9 - 2), (int)0xFFFFFF);
        this.search.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    public void setSelected(StructureListWidget.ListEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        if (this.selected == null) {
            this.loadButton.field_230693_o_ = false;
            return;
        }
        this.loadButton.field_230693_o_ = true;
    }

    public void func_231152_a_(Minecraft mc, int width, int height) {
        String s = this.search.func_146179_b();
        SortType sort = this.sortType;
        StructureListWidget.ListEntry selected = this.selected;
        this.func_231158_b_(mc, width, height);
        this.search.func_146180_a(s);
        this.selected = selected;
        if (!this.search.func_146179_b().isEmpty()) {
            this.reloadStructures();
        }
        if (sort != SortType.NORMAL) {
            this.resortStructures(sort);
        }
        this.updateCache();
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(null);
    }

    private static enum SortType {
        NORMAL,
        A_TO_Z,
        Z_TO_A;

        Button button;

        ITextComponent getButtonText() {
            return new TranslationTextComponent("structurecompass.screen.search." + this.name().toLowerCase(Locale.ROOT));
        }
    }
}

