/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.compat.gamestages;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.darkhax.gamestages.GameStageHelper;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class GameStagesHelper {
    public static final Map<ResourceLocation, Set<String>> STRUCTURE_STAGES = new HashMap<ResourceLocation, Set<String>>();

    public static boolean doesPlayerHaveRequiredStage(PlayerEntity player, ResourceLocation structureLocation) {
        if (STRUCTURE_STAGES.containsKey(structureLocation)) {
            IStageData playerData;
            Set stages = STRUCTURE_STAGES.computeIfAbsent(structureLocation, s -> new HashSet());
            if (!stages.isEmpty() && (playerData = GameStageHelper.getPlayerData((PlayerEntity)player)) != null) {
                for (String stage : stages) {
                    if (!playerData.hasStage(stage)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

