/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.structurecompass.items;

import com.mrbysco.structurecompass.client.ClientHandler;
import com.mrbysco.structurecompass.config.StructureConfig;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureCompassItem
extends Item {
    public StructureCompassItem(Item.Properties builder) {
        super(builder);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (playerIn.func_225608_bj_()) {
            if (worldIn.field_72995_K) {
                ClientHandler.openStructureScreen(playerIn, hand, stack);
            }
        } else {
            this.locateStructure(stack, playerIn);
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    private void locateStructure(ItemStack stack, PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("structurecompass:structureName")) {
                ServerWorld worldIn = (ServerWorld)player.field_70170_p;
                CompoundNBT tag = stack.func_77978_p();
                String boundStructure = tag.func_74779_i("structurecompass:structureName");
                ResourceLocation structureLocation = ResourceLocation.func_208304_a((String)boundStructure);
                if (structureLocation != null) {
                    Structure structure = (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(structureLocation);
                    if (structure != null) {
                        BlockPos structurePos;
                        int searchRange = (Integer)StructureConfig.COMMON.compassRange.get();
                        boolean findUnexplored = false;
                        if (StructureConfig.COMMON.locateUnexplored.get() != null) {
                            findUnexplored = (Boolean)StructureConfig.COMMON.locateUnexplored.get();
                        }
                        if ((structurePos = worldIn.func_241117_a_(structure, player.func_233580_cy_(), searchRange, findUnexplored)) == null) {
                            BlockPos spawnPos = worldIn.func_241135_u_();
                            tag.func_74757_a("structurecompass:structureFound", false);
                            tag.func_74772_a("structurecompass:structurePosition", spawnPos.func_218275_a());
                            player.func_145747_a((ITextComponent)new TranslationTextComponent("structurecompass.structure.failed", new Object[]{boundStructure}).func_240699_a_(TextFormatting.GOLD), Util.field_240973_b_);
                        } else {
                            tag.func_74757_a("structurecompass:structureFound", true);
                            tag.func_74772_a("structurecompass:structurePosition", structurePos.func_218275_a());
                        }
                        stack.func_77982_d(tag);
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("structurecompass.locate.fail").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                }
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("structurecompass.structure.unset.tooltip").func_240699_a_(TextFormatting.YELLOW), Util.field_240973_b_);
            }
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            String structureName = tag.func_74779_i("structurecompass:structureName");
            boolean structureFound = tag.func_74767_n("structurecompass:structureFound");
            if (structureFound) {
                tooltip.add((ITextComponent)new TranslationTextComponent("structurecompass.structure.found.tooltip", new Object[]{structureName, structureName}).func_240699_a_(TextFormatting.GREEN));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("structurecompass.structure.failed.tooltip", new Object[]{structureName}).func_240699_a_(TextFormatting.GOLD));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("structurecompass.structure.unset.tooltip").func_240699_a_(TextFormatting.GOLD));
        }
    }
}

